/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.actf.ai.audio.description.IMetadata;
import org.eclipse.actf.ai.audio.description.IMetadataProvider;
import org.eclipse.actf.ai.audio.io.AudioFactory;
import org.eclipse.actf.ai.audio.io.AudioPipeListener;
import org.eclipse.actf.ai.audio.io.IAudioPipe;
import org.eclipse.actf.ai.audio.io.IAudioReader;
import org.eclipse.actf.ai.audio.io.IAudioWriter;
import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.ai.internal.audio.description.DescriptionPlugin;
import org.eclipse.actf.ai.navigator.IMediaControl;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetadataManager
implements IVoiceEventListener,
AudioPipeListener {
    private IMetadataProvider metadataProvider;
    private IAudioPipe audio;
    private IAudioWriter writer = AudioFactory.createDefaultWriter();
    private int index;
    private int oldIndex;
    private int forceFlag = 0;
    private IMediaControl.IHandle handle;
    private IVideoControl video;
    private ISoundControl sound;
    private boolean stopFlag = false;
    private int voiceIndex = -1;
    private static boolean requestAdditions = false;
    private boolean restart = false;
    private AnalyzedResult analyzedResult;
    private boolean pauseBeforeFlag = false;
    private boolean speakFlag = false;
    private boolean pauseAfterFlag = false;
    private boolean pauseDualingSpeakFlag = false;
    private String addition = "";
    private int additionSpeed;
    private String additionGender;
    private boolean additionFlag;

    public void setForceFlag(int flag) {
        this.forceFlag = flag;
    }

    public MetadataManager(IMediaControl.IHandle handle, IMetadataProvider metadataProvider) {
        this.handle = handle;
        this.video = handle.getVideoControl();
        this.sound = handle.getSoundControl();
        this.metadataProvider = metadataProvider;
        this.oldIndex = -1;
        this.index = -1;
        final IMediaControl.IHandle handle2 = handle;
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!MetadataManager.this.restart) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            System.out.println("play");
                            handle2.getVideoControl().playMedia();
                        }
                    });
                    MetadataManager.this.restart = false;
                }
            }
        };
        thread.start();
        DescriptionPlugin.getDefault().setVoiceEventListener(this);
    }

    public void process(double time) {
        if (this.stopFlag) {
            return;
        }
        DescriptionPlugin.getDefault().getDescriptionView().setTime(time);
        if (this.metadataProvider == null) {
            return;
        }
        this.index = this.metadataProvider.getIndex((int)(time * 100.0));
        IMetadata curMetadata = null;
        if (this.oldIndex != this.index && this.oldIndex < this.index) {
            curMetadata = this.metadataProvider.getItem(this.index);
            int type = curMetadata.getType();
            this.pauseBeforeFlag = this.isIt(type | this.forceFlag, 2);
            this.speakFlag = this.isIt(type | this.forceFlag, 1);
            this.pauseAfterFlag = this.isIt(type | this.forceFlag, 4);
            this.pauseDualingSpeakFlag = this.isIt(type | this.forceFlag, 8);
        }
        if (this.pauseBeforeFlag || this.pauseDualingSpeakFlag) {
            this.pauseBeforeFlag = false;
            this.voiceIndex = 100;
            this.processPause();
        }
        if (this.speakFlag) {
            this.speakFlag = false;
            requestAdditions = false;
            this.processSpeak();
        }
        if (this.pauseAfterFlag) {
            this.pauseAfterFlag = false;
            this.processPause();
        }
        if (this.pauseDualingSpeakFlag) {
            this.pauseDualingSpeakFlag = false;
        }
        this.oldIndex = this.index;
    }

    private boolean isIt(int type, int pause) {
        return (type & pause) == pause;
    }

    private void analyze() {
        this.analyzedResult = new AnalyzedResult();
        Document doc = ModelServiceUtils.getActiveModelService().getLiveDocument();
        Node root = null;
        if (doc != null) {
            root = doc.getFirstChild();
        }
        if (root instanceof INodeEx) {
            this.analyzedResult = ((INodeEx)root).analyze(this.analyzedResult);
        }
    }

    private void processPause() {
        if (DescriptionPlugin.getDefault().getEnable()) {
            this.handle.getVideoControl().pauseMedia();
        }
    }

    private void processPlay() {
        if (DescriptionPlugin.getDefault().getEnable()) {
            this.handle.getVideoControl().playMedia();
        }
    }

    private void processSpeak() {
        if (DescriptionPlugin.getDefault().getEnable()) {
            IMetadata metadata = this.metadataProvider.getItem(this.index);
            if (metadata.hasValidWav()) {
                if (this.audio != null && this.audio.isActive()) {
                    this.audio.stop();
                }
                try {
                    IAudioReader reader = AudioFactory.createAudioReader((URL)new URL(metadata.getWavLocal()));
                    this.audio = AudioFactory.createAudioPipe((IAudioReader)reader, (IAudioWriter)this.writer);
                    this.audio.setBufferSize(100);
                    this.audio.setInterval(1);
                    this.audio.prepare();
                    this.audio.addAudioPipeListener((AudioPipeListener)this);
                    this.audio.start();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                this.say(metadata.getDescription(), metadata.getSpeed(), metadata.getGender());
            }
        }
    }

    private void processAdditionSpeak() {
        if (DescriptionPlugin.getDefault().getEnable()) {
            this.say(this.addition, this.additionSpeed, this.additionGender);
        }
    }

    public void say(String str, int speed, String gender) {
        DescriptionPlugin plugin = DescriptionPlugin.getDefault();
        if (plugin.canSpeak()) {
            plugin.speak(str, speed, gender);
            if (this.voiceIndex != -1) {
                plugin.addSpeakIndex(this.voiceIndex);
            }
        } else {
            this.handle.getVoice().speak(str, true);
        }
    }

    public void stop() {
        this.stopFlag = true;
    }

    public void start() {
        this.stopFlag = false;
        DescriptionPlugin.getDefault().getDescriptionView().setInput(this.metadataProvider);
    }

    public boolean hasMetadata() {
        if (this.metadataProvider == null) {
            return false;
        }
        return this.metadataProvider.hasMetadata();
    }

    public Object getMetadataProvider() {
        return this.metadataProvider;
    }

    public boolean pauseMedia() {
        this.analyze();
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean r = true;
        int i = 0;
        while (i < videos.length) {
            r &= videos[i].pauseMedia();
            ++i;
        }
        return r;
    }

    public boolean playMedia() {
        this.analyze();
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean r = true;
        int i = 0;
        while (i < videos.length) {
            r &= videos[i].playMedia();
            ++i;
        }
        return r;
    }

    public void indexReceived(int index) {
        if (100 == index) {
            this.handle.getVideoControl().playMedia();
            this.voiceIndex = -1;
        } else if (200 == index && this.additionFlag) {
            this.additionFlag = false;
            if (requestAdditions) {
                this.voiceIndex = 100;
                this.handle.getVideoControl().pauseMedia();
                this.processAdditionSpeak();
                requestAdditions = false;
            } else {
                this.voiceIndex = -1;
            }
        }
    }

    public static void requestAdditions() {
        requestAdditions = true;
    }

    public void finished(IAudioPipe pipe) {
        if (this.voiceIndex == 100) {
            this.restart = true;
        }
    }

    public void stopped(IAudioPipe pipe) {
        System.out.println("stop");
    }
}

