/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.views;

import org.eclipse.actf.ai.audio.description.impl.MetadataContentProvider;
import org.eclipse.actf.ai.audio.description.views.VideoStatusViewer;
import org.eclipse.actf.ai.internal.audio.description.DescriptionPlugin;
import org.eclipse.actf.ai.internal.audio.description.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DescriptionView
extends ViewPart {
    public static final String ID = "org.eclipse.actf.ai.audio.description.views.DescriptionView";
    private VideoStatusViewer status;
    private TableViewer tableViewer;

    public void createPartControl(Composite parent) {
        this.initView(parent);
        DescriptionPlugin.getDefault().setDescriptionView(this);
    }

    private void initView(Composite parent) {
        GridLayout gLayout = new GridLayout(1, true);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        parent.setLayout((Layout)gLayout);
        this.status = new VideoStatusViewer(parent);
        this.tableViewer = new TableViewer(parent, 2818);
        MetadataContentProvider provider = new MetadataContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumnProperty = new TableColumn(table, 16384);
        tableColumnProperty.setText(Messages.AudioDescription_view_time);
        tableColumnProperty.setWidth(70);
        TableColumn tableColumnValue = new TableColumn(table, 16384);
        tableColumnValue.setText(Messages.AudioDescription_view_desc);
        tableColumnValue.setWidth(130);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
    }

    public void setFocus() {
    }

    public void setTime(double time) {
        this.status.setTime(time);
    }

    public void setInput(Object input) {
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        this.tableViewer.setInput(input);
    }

    public void setIndex(int index) {
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        this.tableViewer.getTable().select(index);
    }

    public void setEnable(boolean b) {
        this.status.setEnable(b);
    }

    public boolean toggleViewShowing() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView(ID);
        if (part != null) {
            page.hideView(part);
            return false;
        }
        try {
            page.showView(ID);
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }
}

