/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.dltk.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.internal.testing.util.ConsoleLineNotifier;
import org.eclipse.dltk.testing.ITestingProcessor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;

public class TestingConsoleListener
implements IConsoleListener {
    private final String launchKey;
    private final ILaunch launch;
    private final ITestingProcessor processor;
    private boolean initialized = false;
    private boolean finalized = false;

    public TestingConsoleListener(String launchKey, ILaunch launch, ITestingProcessor processor) {
        this.launchKey = launchKey;
        this.launch = launch;
        this.processor = processor;
    }

    public synchronized void consolesAdded(org.eclipse.ui.console.IConsole[] consoles) {
        this.checkConsoles(consoles);
        if (this.initialized) {
            this.uninstall();
        }
    }

    private synchronized void checkConsoles(org.eclipse.ui.console.IConsole[] consoles) {
        if (this.initialized) {
            return;
        }
        int i = 0;
        while (i < consoles.length) {
            ScriptDebugConsole cl;
            ILaunch launch2;
            org.eclipse.ui.console.IConsole console = consoles[i];
            if (console instanceof IConsole) {
                IConsole pc = (IConsole)console;
                IProcess process = pc.getProcess();
                if (process != null && this.launchKey.equals(process.getLaunch().getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY"))) {
                    this.process((TextConsole)console);
                    this.initialized = true;
                }
            } else if (console instanceof ScriptDebugConsole && (launch2 = (cl = (ScriptDebugConsole)console).getLaunch()) != null && this.launchKey.equals(launch2.getAttribute("org.eclipse.dltk.testing.LAUNCH_KEY"))) {
                this.process((TextConsole)cl);
                this.initialized = true;
            }
            ++i;
        }
    }

    private synchronized void done() {
        if (!this.finalized) {
            this.finalized = true;
            this.processor.done();
            this.uninstall();
        }
    }

    private void process(TextConsole pc) {
        pc.addPatternMatchListener((IPatternMatchListener)new ConsoleLineNotifier(){
            private boolean first = true;

            @Override
            public void connect(TextConsole console) {
                super.connect(console);
            }

            @Override
            public synchronized void lineAppended(IRegion region, String content) {
                if (this.first) {
                    this.first = false;
                    TestingConsoleListener.this.processor.start();
                }
                TestingConsoleListener.this.processor.processLine(content);
            }

            @Override
            public synchronized void disconnect() {
                super.disconnect();
                TestingConsoleListener.this.done();
            }

            @Override
            public synchronized void consoleClosed() {
                super.consoleClosed();
                TestingConsoleListener.this.done();
            }
        });
    }

    public void consolesRemoved(org.eclipse.ui.console.IConsole[] consoles) {
    }

    public int hashCode() {
        return this.launchKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestingConsoleListener other = (TestingConsoleListener)obj;
        return this.launchKey.equals(other.launchKey);
    }

    public void install() {
        if (this.initialized) {
            return;
        }
        this.checkConsoles(TestingConsoleListener.getConsoleManager().getConsoles());
        if (!this.initialized) {
            TestingConsoleListener.getConsoleManager().addConsoleListener((IConsoleListener)this);
        }
    }

    public void uninstall() {
        TestingConsoleListener.getConsoleManager().removeConsoleListener((IConsoleListener)this);
    }

    private static IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }
}

