/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.tcl.ast.ComplexString;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclArgumentList;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.DefinitionsFactory;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionUtils;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentDefinition {
    private String name;
    private boolean defaulted = false;
    private boolean isDefaultEmtpy = false;
    private List<Argument> uses = new ArrayList<Argument>();
    private TclArgument argument;
    private static DefinitionsFactory factory = DefinitionsFactory.eINSTANCE;

    public static List<ArgumentDefinition> get(TclArgument tclArgument) {
        ArrayList<ArgumentDefinition> list = new ArrayList<ArgumentDefinition>();
        if (tclArgument instanceof StringArgument || tclArgument instanceof ComplexString || tclArgument instanceof Substitution || tclArgument instanceof VariableReference) {
            list.add(new ArgumentDefinition(tclArgument));
        } else if (tclArgument instanceof TclArgumentList) {
            for (TclArgument sub : ((TclArgumentList)tclArgument).getArguments()) {
                list.add(new ArgumentDefinition(sub));
            }
        }
        return list;
    }

    private ArgumentDefinition(TclArgument argument) {
        this.argument = argument;
        if (argument instanceof StringArgument) {
            this.name = ((StringArgument)argument).getValue();
        } else if (argument instanceof ComplexString || argument instanceof Substitution || argument instanceof VariableReference) {
            this.name = "";
        } else if (argument instanceof TclArgumentList) {
            EList<TclArgument> args = ((TclArgumentList)argument).getArguments();
            if (args.size() == 0) {
                this.name = null;
            }
            TclArgument nameArg = (TclArgument)args.get(0);
            if (args.size() > 1) {
                TclArgument def = (TclArgument)args.get(1);
                if (def instanceof StringArgument && "{}".equals(((StringArgument)def).getValue())) {
                    this.isDefaultEmtpy = true;
                }
                this.defaulted = true;
            }
            if (nameArg instanceof StringArgument) {
                this.name = ((StringArgument)nameArg).getValue();
            } else if (nameArg instanceof TclArgumentList) {
                TclArgument sub = (TclArgument)((TclArgumentList)nameArg).getArguments().get(0);
                this.name = sub instanceof StringArgument ? ((StringArgument)sub).getValue() : "";
            }
        }
        if (this.name != null && this.name.startsWith("{")) {
            this.name = null;
        }
    }

    public Argument createArgument() {
        if (this.uses.size() > 0) {
            Argument arg = DefinitionUtils.copyArgument(this.uses.get(0));
            if (arg instanceof TypedArgument) {
                ((TypedArgument)arg).setName(this.name);
            }
            return arg;
        }
        TypedArgument arg = factory.createTypedArgument();
        arg.setName(this.name);
        return arg;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public TclArgument getArgument() {
        return this.argument;
    }

    public List<Argument> getUses() {
        return this.uses;
    }

    public boolean isDefaultEmtpy() {
        return this.isDefaultEmtpy;
    }
}

