/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathContainerExtension;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.launching.DLTKInterpreterManager;
import org.eclipse.dltk.launching.IInterpreterContainerExtension;
import org.eclipse.dltk.launching.IInterpreterContainerExtension2;
import org.eclipse.dltk.launching.IInterpreterContainerExtension3;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.osgi.util.NLS;

public class InterpreterContainer
implements IBuildpathContainer,
IBuildpathContainerExtension {
    private IInterpreterInstall fInterpreterInstall = null;
    private IPath fPath = null;
    private IScriptProject fProject;
    private IBuildpathEntry[] fEntries = null;
    private static final Map<IInterpreterInstall, IBuildpathEntry[]> fgBuildpathEntries = new HashMap<IInterpreterInstall, IBuildpathEntry[]>(10);
    private static ChangeListener changeListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBuildpathEntry[] getBuildpathEntries(IInterpreterInstall interpreter) {
        IBuildpathEntry[] entries;
        Map<IInterpreterInstall, IBuildpathEntry[]> map = fgBuildpathEntries;
        synchronized (map) {
            if (changeListener == null) {
                changeListener = new ChangeListener();
                ScriptRuntime.addInterpreterInstallChangedListener(changeListener);
            }
            entries = fgBuildpathEntries.get(interpreter);
        }
        if (entries == null) {
            entries = InterpreterContainer.computeBuildpathEntries(interpreter);
            map = fgBuildpathEntries;
            synchronized (map) {
                fgBuildpathEntries.put(interpreter, entries);
            }
        }
        return entries;
    }

    private static IBuildpathEntry[] computeBuildpathEntries(IInterpreterInstall interpreter) {
        LibraryLocation[] libs = ScriptRuntime.getLibraryLocations(interpreter);
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(libs.length);
        HashSet<IPath> rawEntries = new HashSet<IPath>(libs.length);
        int i = 0;
        while (i < libs.length) {
            IPath entryPath = libs[i].getLibraryPath();
            if (!entryPath.isEmpty() && !rawEntries.contains(entryPath)) {
                IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
                ArrayList<IPath> excluded = new ArrayList<IPath>();
                int j = 0;
                while (j < libs.length) {
                    IPath pattern;
                    IPath otherPath = libs[j].getLibraryPath();
                    if (!otherPath.isEmpty() && entryPath.isPrefixOf(otherPath) && !otherPath.equals((Object)entryPath) && !excluded.contains(pattern = otherPath.setDevice(null).removeFirstSegments(entryPath.segmentCount()).append("*"))) {
                        excluded.add(pattern);
                    }
                    ++j;
                }
                entries.add(DLTKCore.newLibraryEntry((IPath)entryPath, (IAccessRule[])IAccessRule.EMPTY_RULES, (IBuildpathAttribute[])attributes, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])excluded.toArray(new IPath[excluded.size()]), (boolean)false, (boolean)true));
                rawEntries.add(entryPath);
            }
            ++i;
        }
        entries.add(DLTKCore.newBuiltinEntry((IPath)IBuildpathEntry.BUILTIN_EXTERNAL_ENTRY.append(interpreter.getInstallLocation().toOSString()), (IAccessRule[])IAccessRule.EMPTY_RULES, (IBuildpathAttribute[])new IBuildpathAttribute[0], (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true));
        IInterpreterContainerExtension extension = DLTKInterpreterManager.getInterpreterContainerExtension(interpreter.getNatureId());
        if (extension instanceof IInterpreterContainerExtension2) {
            ((IInterpreterContainerExtension2)extension).preProcessEntries(interpreter, entries);
        }
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public InterpreterContainer(IInterpreterInstall interpreter, IPath path, IScriptProject project) {
        this.fInterpreterInstall = interpreter;
        this.fPath = path;
        this.fProject = project;
    }

    public IBuildpathEntry[] getBuildpathEntries() {
        if (this.fEntries == null) {
            this.fEntries = this.computeBuildpathEntries();
        }
        return this.fEntries;
    }

    private IBuildpathEntry[] computeBuildpathEntries() {
        IBuildpathEntry[] buildpathEntries = InterpreterContainer.getBuildpathEntries(this.fInterpreterInstall);
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>(buildpathEntries.length);
        Collections.addAll(entries, buildpathEntries);
        IInterpreterContainerExtension extension = DLTKInterpreterManager.getInterpreterContainerExtension(this.fProject);
        if (extension != null) {
            extension.processEntres(this.fProject, entries);
        }
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public String getDescription() {
        IInterpreterContainerExtension extension = DLTKInterpreterManager.getInterpreterContainerExtension(this.fProject);
        if (extension instanceof IInterpreterContainerExtension3) {
            return ((IInterpreterContainerExtension3)extension).getDescription(this.fInterpreterInstall);
        }
        String tag = this.fInterpreterInstall.getName();
        return NLS.bind((String)LaunchingMessages.InterpreterEnvironmentContainer_InterpreterEnvironment_System_Library_1, (Object)tag);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IBuiltinModuleProvider getBuiltinProvider() {
        return this.fInterpreterInstall;
    }

    private static class ChangeListener
    implements IInterpreterInstallChangedListener {
        private ChangeListener() {
        }

        @Override
        public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        }

        @Override
        public void interpreterChanged(PropertyChangeEvent event) {
            if (event.getSource() != null && event.getSource() instanceof IInterpreterInstall) {
                this.remove((IInterpreterInstall)event.getSource());
            }
        }

        @Override
        public void interpreterAdded(IInterpreterInstall newInterpreter) {
        }

        @Override
        public void interpreterRemoved(IInterpreterInstall removedInterpreter) {
            this.remove(removedInterpreter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(IInterpreterInstall interpreter) {
            Map map = fgBuildpathEntries;
            synchronized (map) {
                fgBuildpathEntries.remove(interpreter);
            }
        }
    }
}

