/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.rse;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.internal.ui.rse.RSEConnectionMonitor;
import org.eclipse.dltk.internal.ui.rse.RSEConnector;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DLTKRSEUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.rse.ui";
    private static DLTKRSEUI plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        RSEUIPlugin.getDefault();
        RSEConnectionMonitor.start();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        RSEConnector.stop();
        super.stop(context);
    }

    public static DLTKRSEUI getDefault() {
        return plugin;
    }

    private static class ShutdownCloseProjectsWithLinkedFiles
    implements IWorkbenchListener {
        private ShutdownCloseProjectsWithLinkedFiles() {
        }

        public void postShutdown(IWorkbench workbench) {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            this.closeProjectsWithLinkedFiles();
            return true;
        }

        private void closeProjectsWithLinkedFiles() {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    IProject project = iProjectArray[n2];
                    if (project.isAccessible() && DLTKLanguageManager.hasScriptNature((IProject)project)) {
                        try {
                            if (this.shouldBeClosed(project)) {
                                project.close(null);
                            }
                        }
                        catch (CoreException e) {
                            if (!DLTKCore.DEBUG) break block5;
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
        }

        private boolean shouldBeClosed(IProject project) throws CoreException {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI location;
                IResource child = iResourceArray[n2];
                if (child.isLinked() && (location = child.getLocationURI()) != null && "rse".equalsIgnoreCase(location.getScheme())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

