/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;

public class RClassVariable
extends RType {
    @NonNull
    private final TypeVariable variable;

    public RClassVariable(TypeVariable variable) {
        this.variable = variable;
    }

    @Override
    public String getName() {
        return "Class<" + this.variable.getName() + ">";
    }

    public TypeVariable getVariable() {
        return this.variable;
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof IRClassType) {
            return TypeCompatibility.TRUE;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RClassVariable) {
            RClassVariable other = (RClassVariable)obj;
            return this.variable == other.variable;
        }
        return false;
    }
}

