/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parser;

public class PythonParseUtils {
    public static int endLineOrSymbol(int from, String content) {
        int pos = 0;
        pos = from;
        while (pos < content.length()) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos;
            }
            if (!Character.isWhitespace(c)) {
                return pos;
            }
            ++pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return from;
    }

    public static int startLineOrSymbol(int from, String content) {
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        int pos = from - 1;
        while (pos > 0) {
            char c = content.charAt(pos);
            if (c == '\n' || c == '\r' || c == ';') {
                return pos + 1;
            }
            if (!Character.isWhitespace(c)) {
                return pos + 1;
            }
            --pos;
        }
        return from;
    }

    public static int endLineOrNoSymbol(int from, String content) {
        int pos = 0;
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        pos = from;
        while (pos < content.length()) {
            if (PythonParseUtils.checkBounds(content, pos) && (content.charAt(pos) != '$' || pos != from)) {
                return pos;
            }
            ++pos;
        }
        if (pos == content.length()) {
            return pos;
        }
        return pos;
    }

    private static boolean checkBounds(String content, int pos) {
        char[] syms = new char[]{' ', '\t', '\n', '\r', ']', '[', '}', '{', '(', ')', '$'};
        char c = content.charAt(pos);
        int i = 0;
        while (i < syms.length) {
            if (syms[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int startLineOrNoSymbol(int from, String content) {
        if (from == -1) {
            from = 0;
        }
        if (from >= content.length()) {
            --from;
        }
        int pos = from;
        while (pos > 0) {
            if (PythonParseUtils.checkBounds(content, pos)) {
                if (content.charAt(pos) == '$') {
                    return pos;
                }
                return pos + 1;
            }
            --pos;
        }
        return pos;
    }
}

