/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parsers;

import java.util.List;
import java.util.Vector;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class PythonTokenStream
implements TokenSource {
    public static final int MAX_INDENTS = 100;
    public static final int FIRST_CHAR_POSITION = 0;
    private int[] identation = new int[100];
    private int tabposition = -1;
    private Vector tokenBuffer = new Vector();
    private CommonTokenStream stream;
    private int lastIndex = -1;

    public PythonTokenStream(CommonTokenStream stream) {
        this.stream = stream;
        this.push(0);
    }

    public Token nextToken() {
        if (this.tokenBuffer.size() > 0) {
            Token t = (Token)this.tokenBuffer.firstElement();
            this.tokenBuffer.removeElementAt(0);
            return t;
        }
        this.insertFakeTokens();
        return this.nextToken();
    }

    protected void insertFakeTokens() {
        Token tok = this.stream.LT(1);
        this.stream.consume();
        if (tok.getType() != 6) {
            List hiddenTokens = this.stream.getTokens(this.lastIndex + 1, tok.getTokenIndex() - 1);
            if (hiddenTokens != null) {
                this.tokenBuffer.addAll(hiddenTokens);
            }
            this.lastIndex = tok.getTokenIndex();
            this.tokenBuffer.addElement(tok);
            return;
        }
        List hiddenTokens = this.stream.getTokens(this.lastIndex + 1, tok.getTokenIndex() - 1);
        if (hiddenTokens != null) {
            this.tokenBuffer.addAll(hiddenTokens);
        }
        this.lastIndex = tok.getTokenIndex();
        this.tokenBuffer.addElement(tok);
        tok = this.stream.LT(1);
        this.stream.consume();
        hiddenTokens = this.stream.getTokens(this.lastIndex + 1, tok.getTokenIndex() - 1);
        if (hiddenTokens != null) {
            this.tokenBuffer.addAll(hiddenTokens);
        }
        this.lastIndex = tok.getTokenIndex();
        int cpos = tok.getCharPositionInLine();
        if (tok.getType() == -1) {
            cpos = -1;
        } else if (tok.getType() == 66) {
            cpos = tok.getText().length();
        }
        int lastIndent = this.peek();
        if (cpos > lastIndent) {
            this.push(cpos);
            this.createAddToken(4, tok);
        } else if (cpos < lastIndent) {
            int prevIndex = this.findPreviousIndent(cpos);
            int d = this.tabposition - 1;
            while (d >= prevIndex) {
                this.createAddToken(5, tok);
                --d;
            }
            this.tabposition = prevIndex;
        }
        if (tok.getType() != 66) {
            this.tokenBuffer.addElement(tok);
        }
    }

    private void createAddToken(int type, Token tok) {
        ClassicToken token = new ClassicToken(type, "");
        token.setCharPositionInLine(tok.getCharPositionInLine());
        token.setLine(tok.getLine());
        this.tokenBuffer.addElement(token);
    }

    protected void push(int i) {
        if (this.tabposition >= 100) {
            throw new IllegalStateException("stack overflow");
        }
        ++this.tabposition;
        this.identation[this.tabposition] = i;
    }

    protected int pop() {
        if (this.tabposition < 0) {
            throw new IllegalStateException("stack underflow");
        }
        int top = this.identation[this.tabposition];
        --this.tabposition;
        return top;
    }

    protected int peek() {
        return this.identation[this.tabposition];
    }

    protected int findPreviousIndent(int i) {
        int j = this.tabposition - 1;
        while (j >= 0) {
            if (this.identation[j] == i) {
                return j;
            }
            --j;
        }
        return 0;
    }
}

