/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.core.search.matching.PossibleMatch;
import org.eclipse.dltk.tcl.core.TclKeywordsManager;

public abstract class BasicTclMatchLocatorParser
extends MatchLocatorParser {
    protected static final String[] kw = TclKeywordsManager.getKeywords();
    protected static Map kwMap = new HashMap();

    static {
        int q = 0;
        while (q < kw.length) {
            kwMap.put(kw[q], Boolean.TRUE);
            ++q;
        }
    }

    public BasicTclMatchLocatorParser(MatchLocator locator) {
        super(locator);
    }

    public ModuleDeclaration parse(PossibleMatch possibleMatch) {
        ModuleDeclaration module = super.parse(possibleMatch);
        module.rebuild();
        module.rebuildMethods();
        return module;
    }

    public void parseBodies(ModuleDeclaration unit) {
        MethodDeclaration[] methods;
        TypeDeclaration[] types = unit.getTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                this.getPatternLocator().match(this.processType(type), this.getNodeSet());
                this.parseBodies(type);
                ++i;
            }
        }
        if ((methods = unit.getFunctions()) != null) {
            PatternLocator locator = this.getPatternLocator();
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                locator.match(this.processMethod(method), this.getNodeSet());
                this.parseBodies(method);
                ++i;
            }
        }
        ASTNode[] nodes = unit.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            this.processStatement(nodes[i]);
            ++i;
        }
    }

    public MethodDeclaration processMethod(MethodDeclaration m) {
        String name = m.getName();
        MethodDeclaration method = new MethodDeclaration(m.sourceStart(), m.sourceEnd()){

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof ASTNode) {
                    ASTNode s = (ASTNode)obj;
                    if (s.sourceEnd() < 0 || s.sourceStart() < 0) {
                        return false;
                    }
                    return this.sourceStart() == s.sourceStart() && this.sourceEnd() == s.sourceEnd();
                }
                return false;
            }

            public int hashCode() {
                return this.sourceEnd() * 1001 + this.sourceEnd();
            }
        };
        method.setName(name);
        method.setNameStart(m.getNameStart());
        method.setNameEnd(m.getNameEnd());
        method.setModifiers(m.getModifiers());
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        name = this.getRealMethodName(method);
        method.setDeclaringTypeName(m.getDeclaringTypeName());
        method.setName(name);
        return method;
    }

    public String getRealMethodName(MethodDeclaration method) {
        String name = method.getName();
        if (name.indexOf("::") != -1) {
            int pos = name.lastIndexOf("::");
            name = name.substring(pos + 2);
        }
        return name;
    }

    public TypeDeclaration processType(TypeDeclaration t) {
        String name = t.getName();
        TypeDeclaration type = new TypeDeclaration(name, t.getNameStart(), t.getNameEnd(), t.sourceStart(), t.sourceEnd()){

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof ASTNode) {
                    ASTNode s = (ASTNode)obj;
                    if (s.sourceEnd() < 0 || s.sourceStart() < 0) {
                        return false;
                    }
                    return this.sourceStart() == s.sourceStart() && this.sourceEnd() == s.sourceEnd();
                }
                return false;
            }

            public int hashCode() {
                return this.sourceEnd() * 1001 + this.sourceEnd();
            }
        };
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        if (name.endsWith("::")) {
            name = name.substring(0, name.length() - 2);
        }
        type.setName(name);
        type.setEnclosingTypeName(t.getEnclosingTypeName());
        type.setModifier(t.getModifiers());
        return type;
    }

    protected void parseBodies(TypeDeclaration type) {
        TypeDeclaration[] memberTypes;
        PatternLocator locator = this.getPatternLocator();
        MethodDeclaration[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                locator.match(this.processMethod(method), this.getNodeSet());
                this.parseBodies(method);
                ++i;
            }
        }
        if ((memberTypes = type.getTypes()) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                TypeDeclaration memberType = memberTypes[i];
                locator.match(this.processType(memberType), this.getNodeSet());
                this.parseBodies(memberType);
                ++i;
            }
        }
        ASTNode[] nodes = type.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            this.processStatement(nodes[i]);
            ++i;
        }
    }

    protected void parseBodies(MethodDeclaration method) {
        List nodes = method.getStatements();
        int length = nodes.size();
        int i = 0;
        while (i < length) {
            ASTNode node = (ASTNode)nodes.get(i);
            this.processStatement(node);
            ++i;
        }
    }

    protected abstract void processStatement(ASTNode var1);
}

