/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteFromBuildpathChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class AddToBuildpathChange
extends DLTKChange {
    private IScriptProject fProjectHandle;
    private IBuildpathEntry fEntryToAdd;

    public AddToBuildpathChange(IScriptProject project, IBuildpathEntry entryToAdd) {
        this.fProjectHandle = project;
        this.fEntryToAdd = entryToAdd;
    }

    public AddToBuildpathChange(IScriptProject project, String sourceFolderName) {
        this(project, DLTKCore.newSourceEntry((IPath)project.getPath().append(sourceFolderName)));
    }

    public AddToBuildpathChange(IScriptProject project, IPath newProjectEntry) {
        this(project, DLTKCore.newProjectEntry((IPath)newProjectEntry));
    }

    public AddToBuildpathChange(IScriptProject project, int entryKind, IPath path) {
        this(project, AddToBuildpathChange.createNewBuildpathEntry(entryKind, path));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 1);
        try {
            if (this.validateBuildpath()) {
                this.getScriptProject().setRawBuildpath(this.getNewBuildpathEntries(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                IPath buildpathEntryPath = this.fEntryToAdd.getPath();
                DeleteFromBuildpathChange deleteFromBuildpathChange = new DeleteFromBuildpathChange(buildpathEntryPath, this.getScriptProject());
                return deleteFromBuildpathChange;
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            pm.done();
        }
    }

    public boolean validateBuildpath() throws ModelException {
        IScriptProject scriptProject = this.getScriptProject();
        IBuildpathEntry[] newClasspathEntries = this.getNewBuildpathEntries();
        return BuildpathEntry.validateBuildpath((IScriptProject)scriptProject, (IBuildpathEntry[])newClasspathEntries).isOK();
    }

    private IBuildpathEntry[] getNewBuildpathEntries() throws ModelException {
        IBuildpathEntry[] entries = this.getScriptProject().getRawBuildpath();
        ArrayList<IBuildpathEntry> cp = new ArrayList<IBuildpathEntry>(entries.length + 1);
        cp.addAll(Arrays.asList(entries));
        cp.add(this.fEntryToAdd);
        return cp.toArray(new IBuildpathEntry[cp.size()]);
    }

    private static IBuildpathEntry createNewBuildpathEntry(int kind, IPath path) {
        switch (kind) {
            case 1: {
                return DLTKCore.newLibraryEntry((IPath)path);
            }
            case 2: {
                return DLTKCore.newProjectEntry((IPath)path);
            }
            case 3: {
                return DLTKCore.newSourceEntry((IPath)path);
            }
            case 5: {
                return DLTKCore.newContainerEntry((IPath)path);
            }
            case 4: {
                return DLTKCore.newVariableEntry((IPath)path);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private IScriptProject getScriptProject() {
        return this.fProjectHandle;
    }

    public String getName() {
        return NLS.bind((String)RefactoringCoreMessages.AddToClasspathChange_add, (Object)this.getScriptProject().getElementName());
    }

    public Object getModifiedElement() {
        return this.getScriptProject();
    }

    public IBuildpathEntry getBuildpathEntry() {
        return this.fEntryToAdd;
    }
}

