/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ScriptAnnotationIterator
implements Iterator<Annotation> {
    private Iterator<?> fIterator;
    private Annotation fNext;
    private boolean fReturnAllAnnotations;

    @Deprecated
    public ScriptAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants, boolean returnAllAnnotations) {
        this(model, returnAllAnnotations);
    }

    public ScriptAnnotationIterator(IAnnotationModel model, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = model != null ? model.getAnnotationIterator() : Collections.EMPTY_LIST.iterator();
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = (Annotation)this.fIterator.next();
            if (next.isMarkedDeleted() || !this.fReturnAllAnnotations && !(next instanceof IScriptAnnotation) && !ScriptAnnotationIterator.isProblemMarkerAnnotation(next)) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    private static boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.fNext != null;
    }

    @Override
    public Annotation next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

