/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropAdapter;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptCopyProcessor;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ScriptMoveProcessor;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends DLTKViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private ScriptMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private ScriptCopyProcessor fCopyProcessor;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setSelectionFeedbackEnabled(false);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IModelElement || target instanceof IResource;
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.setSelectionFeedbackEnabled(false);
        this.fElements = null;
        this.fSelection = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    @Override
    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        int result = this.internalDetermineOperation(target, operation, operations);
        if (result == 0) {
            this.setSelectionFeedbackEnabled(false);
        } else {
            this.setSelectionFeedbackEnabled(true);
        }
        return result;
    }

    private int internalDetermineOperation(Object target, int operation, int operations) {
        this.initializeSelection();
        if (target == null) {
            return 0;
        }
        if (this.getCurrentLocation() == 3) {
            IModelElement[] javaElements = ReorgUtils.getModelElements(this.fElements);
            if (this.contains(javaElements, target)) {
                return 0;
            }
            IResource[] resources = ReorgUtils.getResources(this.fElements);
            if (this.contains(resources, target)) {
                return 0;
            }
        }
        try {
            switch (operation) {
                case 16: {
                    return this.handleValidateDefault(target, operations);
                }
                case 1: {
                    return this.handleValidateCopy(target);
                }
                case 2: {
                    return this.handleValidateMove(target);
                }
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ScriptMessages.SelectionTransferDropAdapter_error_title, ScriptMessages.SelectionTransferDropAdapter_error_message);
        }
        return 0;
    }

    private boolean contains(IResource[] resources, Object target) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IModelElement[] elements, Object target) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            this.fSelection = StructuredSelection.EMPTY;
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    @Override
    public boolean performDrop(Object data) {
        try {
            switch (this.getCurrentOperation()) {
                case 2: {
                    this.handleDropMove(this.getCurrentTarget());
                    break;
                }
                case 1: {
                    this.handleDropCopy(this.getCurrentTarget());
                }
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), ScriptMessages.SelectionTransferDropAdapter_error_title, ScriptMessages.SelectionTransferDropAdapter_error_message);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private int handleValidateDefault(Object target, int operations) throws ModelException {
        int result;
        if ((operations & 2) != 0 && (result = this.handleValidateMove(target)) != 0) {
            return result;
        }
        return this.handleValidateCopy(target);
    }

    private int handleValidateMove(Object target) throws ModelException {
        IReorgPolicy.IMovePolicy policy;
        if (this.fMoveProcessor == null && (policy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements))).canEnable()) {
            this.fMoveProcessor = new ScriptMoveProcessor(policy);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            return 0;
        }
        if (target instanceof IModelElement && !this.fMoveProcessor.setDestination((IModelElement)target).isOK()) {
            return 0;
        }
        if (target instanceof IResource && !this.fMoveProcessor.setDestination((IResource)target).isOK()) {
            return 0;
        }
        return 2;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropMove(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        IModelElement[] modelElements = ReorgUtils.getModelElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgMoveStarter starter = null;
        if (target instanceof IResource) {
            starter = ReorgMoveStarter.create(modelElements, resources, (IResource)target);
        } else if (target instanceof IModelElement) {
            starter = ReorgMoveStarter.create(modelElements, resources, (IModelElement)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target) throws ModelException {
        if (this.fCopyProcessor == null) {
            IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getModelElements(this.fElements));
            ScriptCopyProcessor scriptCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new ScriptCopyProcessor(policy) : null;
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (this.fCopyProcessor == null) {
            return 0;
        }
        if (target instanceof IModelElement && !this.fCopyProcessor.setDestination((IModelElement)target).isOK()) {
            return 0;
        }
        if (target instanceof IResource && !this.fCopyProcessor.setDestination((IResource)target).isOK()) {
            return 0;
        }
        return 1;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object target) throws ModelException, InvocationTargetException, InterruptedException {
        IModelElement[] modelElements = ReorgUtils.getModelElements(this.fElements);
        IResource[] resources = ReorgUtils.getResources(this.fElements);
        ReorgCopyStarter starter = null;
        if (target instanceof IModelElement) {
            starter = ReorgCopyStarter.create(modelElements, resources, (IModelElement)target);
        } else if (target instanceof IResource) {
            starter = ReorgCopyStarter.create(modelElements, resources, (IResource)target);
        }
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    @Override
    protected int getCurrentLocation() {
        if (this.getFeedbackEnabled()) {
            return super.getCurrentLocation();
        }
        return 3;
    }
}

