/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.dialogs;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PropertyLinkArea {
    private Link pageLink;
    private IAdaptable element;

    public PropertyLinkArea(Composite parent, int style, final String pageId, IAdaptable element, String message, final IWorkbenchPreferenceContainer pageContainer) {
        this.element = element;
        this.pageLink = new Link(parent, style);
        IPreferenceNode node = this.getPreferenceNode(pageId);
        String text = null;
        text = node == null ? NLS.bind((String)WorkbenchMessages.PreferenceNode_NotFound, (Object)pageId) : NLS.bind((String)message, (Object)node.getLabelText());
        this.pageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                pageContainer.openPage(pageId, null);
            }
        });
        this.pageLink.setText(text);
    }

    public Control getControl() {
        return this.pageLink;
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        PropertyPageManager pageManager = new PropertyPageManager();
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)this.element);
        for (IPreferenceNode node : pageManager.getElements(0)) {
            if (!node.getId().equals(pageId)) continue;
            return node;
        }
        return null;
    }
}

