/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.CorrectionEngine;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ScriptMarkerAnnotation
extends MarkerAnnotation
implements IScriptAnnotation {
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.dltk.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.dltk.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.eclipse.dltk.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IScriptAnnotation fOverlay;

    public ScriptMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    @Override
    public String[] getArguments() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return CorrectionEngine.getProblemArguments((IMarker)marker);
        }
        return null;
    }

    @Override
    public IProblemIdentifier getId() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return null;
        }
        if (this.isProblem()) {
            return DefaultProblemIdentifier.getProblemId((IMarker)marker);
        }
        return null;
    }

    @Override
    public boolean isProblem() {
        String type = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(type) || ERROR_ANNOTATION_TYPE.equals(type);
    }

    public void setOverlay(IScriptAnnotation javaAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = javaAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    @Override
    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    @Override
    public IScriptAnnotation getOverlay() {
        return this.fOverlay;
    }

    @Override
    public void addOverlaid(IScriptAnnotation annotation) {
    }

    @Override
    public void removeOverlaid(IScriptAnnotation annotation) {
    }

    @Override
    public Iterator getOverlaidIterator() {
        return null;
    }

    @Override
    public ISourceModule getSourceModule() {
        IModelElement element = DLTKCore.create((IResource)this.getMarker().getResource());
        if (element instanceof ISourceModule) {
            return (ISourceModule)element;
        }
        return null;
    }

    @Override
    public String getMarkerType() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return null;
        }
        return MarkerUtilities.getMarkerType((IMarker)this.getMarker());
    }

    @Override
    public int getSourceStart() {
        return MarkerUtilities.getCharStart((IMarker)this.getMarker());
    }

    @Override
    public int getSourceEnd() {
        return MarkerUtilities.getCharEnd((IMarker)this.getMarker());
    }
}

