/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.templates.TemplateInformationControlCreator;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public abstract class ScriptTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Comparator<TemplateProposal> comparator = new ProposalComparator();
    private final ScriptContentAssistInvocationContext context;
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";

    public ScriptTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
    }

    protected ScriptContentAssistInvocationContext getContext() {
        return this.context;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Template template;
        int i;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        ArrayList<TemplateProposal> matches = new ArrayList<TemplateProposal>();
        if (selection.getLength() == 0) {
            String prefix = this.extractPrefix(viewer, offset);
            if (!this.isValidPrefix(prefix)) {
                return new ICompletionProposal[0];
            }
            Region region = new Region(offset - prefix.length(), prefix.length());
            TemplateContext context = this.createContext(viewer, (IRegion)region);
            if (context == null) {
                return new ICompletionProposal[0];
            }
            context.setVariable("selection", selection.getText());
            Template[] templates = this.getTemplates(context.getContextType().getId());
            i = 0;
            while (i != templates.length) {
                block15: {
                    template = templates[i];
                    try {
                        context.getContextType().validate(template.getPattern());
                    }
                    catch (TemplateException templateException) {
                        break block15;
                    }
                    if (this.isMatchingTemplate(template, prefix, context)) {
                        matches.add((TemplateProposal)this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                    }
                }
                ++i;
            }
        } else {
            Region region = new Region(offset - selection.getLength(), selection.getLength());
            TemplateContext context = this.createContext(viewer, (IRegion)region);
            if (context == null) {
                return new ICompletionProposal[0];
            }
            context.setVariable("selection", selection.getText());
            Template[] templates = this.getTemplates(context.getContextType().getId());
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            i = 0;
            while (i != templates.length) {
                block16: {
                    template = templates[i];
                    try {
                        context.getContextType().validate(template.getPattern());
                    }
                    catch (TemplateException templateException) {
                        break block16;
                    }
                    if (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1) {
                        matches.add((TemplateProposal)this.createProposal(template, context, (IRegion)region, this.getRelevance(template)));
                    }
                }
                ++i;
            }
        }
        Collections.sort(matches, comparator);
        IInformationControlCreator controlCreator = this.getInformationControlCreator();
        for (TemplateProposal proposal : matches) {
            proposal.setInformationControlCreator(controlCreator);
        }
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean isValidPrefix(String prefix) {
        return prefix.length() != 0;
    }

    protected boolean isMatchingTemplate(Template template, String prefix, TemplateContext context) {
        return template.getName().startsWith(prefix) && template.matches(prefix, context.getContextType().getId());
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType instanceof ScriptTemplateContextType) {
            IDocument document = viewer.getDocument();
            ISourceModule sourceModule = this.getContext().getSourceModule();
            if (sourceModule == null) {
                return null;
            }
            return ((ScriptTemplateContextType)contextType).createContext(document, region.getOffset(), region.getLength(), sourceModule);
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new ScriptTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected IInformationControlCreator getInformationControlCreator() {
        int orientation = Window.getDefaultOrientation();
        IEditorPart editor = this.getContext().getEditor();
        if (editor == null) {
            editor = DLTKUIPlugin.getActivePage().getActiveEditor();
        }
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getContext().getLanguageNatureID());
        if (toolkit == null && editor instanceof ScriptEditor) {
            toolkit = ((ScriptEditor)editor).getLanguageToolkit();
        }
        return new TemplateInformationControlCreator(orientation, toolkit);
    }

    protected abstract String getContextTypeId();

    protected abstract ScriptTemplateAccess getTemplateAccess();

    protected Template[] getTemplates(String contextTypeId) {
        return this.getTemplateAccess().getTemplateStore().getTemplates(contextTypeId);
    }

    protected char[] getIgnore() {
        return CharOperation.NO_CHAR;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        if (this.isValidLocation(viewer, region)) {
            return this.getTemplateAccess().getContextTypeRegistry().getContextType(this.getContextTypeId());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValidLocation(ITextViewer viewer, IRegion region) {
        try {
            String trigger = this.getTrigger(viewer, region);
            char[] ignore = this.getIgnore();
            int i = 0;
            while (true) {
                if (i >= ignore.length) {
                    return true;
                }
                if (trigger.indexOf(ignore[i]) != -1) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            if (!DLTKCore.DEBUG) return false;
            e.printStackTrace();
            return false;
        }
    }

    protected Image getImage(Template template) {
        return DLTKPluginImages.get("org.eclipse.dltk.ui.template_obj.png");
    }

    protected String getTrigger(ITextViewer viewer, IRegion region) throws BadLocationException {
        int regionEnd;
        IRegion line;
        IDocument doc = viewer.getDocument();
        String s = doc.get((line = doc.getLineInformationOfOffset(regionEnd = region.getOffset() + region.getLength())).getOffset(), regionEnd - line.getOffset());
        int spaceIndex = s.lastIndexOf(32);
        if (spaceIndex != -1) {
            return s.substring(spaceIndex);
        }
        return s;
    }

    protected int getRelevance(Template template) {
        return 0;
    }

    private static final class ProposalComparator
    implements Comparator<TemplateProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(TemplateProposal o1, TemplateProposal o2) {
            return o2.getRelevance() - o1.getRelevance();
        }
    }
}

