/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.heredoc;

import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.heredoc.HereDocEnabledPartitionScanner;
import org.eclipse.dltk.ui.text.heredoc.HereDocUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class HereDocEnabledPartitioner
extends FastPartitioner {
    private boolean fIsInitialized;
    private String fPositionCategory;
    private HereDocEnabledPartitionScanner fScanner;

    public HereDocEnabledPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
        Assert.isTrue((boolean)(scanner instanceof HereDocEnabledPartitionScanner));
        this.fScanner = (HereDocEnabledPartitionScanner)scanner;
        this.fPositionCategory = this.getManagingPositionCategories()[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion documentChanged2(DocumentEvent e) {
        if (!this.fIsInitialized) {
            return null;
        }
        try {
            Assert.isTrue((boolean)(e.getDocument() == this.fDocument));
            category = this.getPositions();
            line = this.fDocument.getLineInformationOfOffset(e.getOffset());
            reparseStart = line.getOffset();
            partitionStart = -1;
            contentType = null;
            newLength = e.getText() == null ? 0 : e.getText().length();
            first = this.fDocument.computeIndexInCategory(this.fPositionCategory, reparseStart);
            if (first > 0) {
                partition = (TypedPosition)category[first - 1];
                if (HereDocUtils.isHereDocContent(partition.getType())) {
                    partitionStart = reparseStart = this.findReparseStartForHereDoc(category, first, partition);
                    --first;
                } else if (partition.includes(reparseStart)) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    if (e.getOffset() == partition.getOffset() + partition.getLength()) {
                        reparseStart = partitionStart;
                    }
                    --first;
                } else if (reparseStart == e.getOffset() && reparseStart == partition.getOffset() + partition.getLength()) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    reparseStart = partitionStart;
                    --first;
                } else {
                    partitionStart = reparseStart;
                    contentType = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(e);
            i = first;
            while (i < category.length) {
                p = category[i];
                if (p.isDeleted) {
                    this.rememberDeletedOffset(e.getOffset());
                    break;
                }
                ++i;
            }
            this.clearPositionCache();
            category = this.getPositions();
            this.fScanner.setPartialRange(this.fDocument, reparseStart, this.fDocument.getLength() - reparseStart, contentType, partitionStart);
            behindLastScannedPosition = reparseStart;
            token = this.fScanner.nextToken();
            if (true) ** GOTO lbl76
        }
        catch (BadPositionCategoryException v0) {
            this.clearPositionCache();
            return this.createRegion();
        }
        catch (BadLocationException v1) {
            try {
                return this.createRegion();
            }
            catch (Throwable var15_18) {
                throw var15_18;
            }
            finally {
                this.clearPositionCache();
            }
        }
lbl60:
        // 1 sources

        while (true) {
            this.clearPositionCache();
            return var16_17;
        }
        {
            do {
                ++first;
                if (true) ** GOTO lbl74
                block14: do {
                    try {
                        this.fDocument.addPosition(this.fPositionCategory, (Position)new TypedPosition(start, length, contentType));
                        this.rememberRegion(start, length);
                    }
                    catch (BadPositionCategoryException v2) {
                    }
                    catch (BadLocationException v3) {}
                    token = this.fScanner.nextToken();
lbl76:
                    // 2 sources

                    while (true) {
                        block30: {
                            if (!token.isEOF()) break block30;
                            first = this.fDocument.computeIndexInCategory(this.fPositionCategory, behindLastScannedPosition);
                            this.clearPositionCache();
                            category = this.getPositions();
                            if (true) ** GOTO lbl111
                        }
                        contentType = this.getTokenContentType(token);
                        if (this.isSupportedContentType(contentType)) break;
                        token = this.fScanner.nextToken();
                    }
                    start = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    behindLastScannedPosition = start + length;
                    lastScannedPosition = behindLastScannedPosition - 1;
                    while (first < category.length) {
                        p = (TypedPosition)category[first];
                        if (lastScannedPosition >= p.offset + p.length || p.overlapsWith(start, length) && (!this.fDocument.containsPosition(this.fPositionCategory, start, length) || !contentType.equals(p.getType()))) {
                            this.rememberRegion(p.offset, p.length);
                            this.fDocument.removePosition(this.fPositionCategory, (Position)p);
                            ++first;
                            continue;
                        }
                        if (!HereDocUtils.isHereDocContent(contentType)) continue block14;
                        this.rememberRegion(p.offset, p.length);
                        this.fDocument.removePosition(this.fPositionCategory, (Position)p);
                        ++first;
                    }
                } while (!this.fDocument.containsPosition(this.fPositionCategory, start, length));
            } while (lastScannedPosition < e.getOffset() + newLength);
            var16_17 = this.createRegion();
            ** continue;
            do {
                p = (TypedPosition)category[first++];
                this.fDocument.removePosition(this.fPositionCategory, (Position)p);
                this.rememberRegion(p.offset, p.length);
lbl111:
                // 2 sources

            } while (first < category.length);
        }
        this.clearPositionCache();
        return this.createRegion();
    }

    private int findReparseStartForHereDoc(Position[] category, int first, TypedPosition partition) throws BadLocationException {
        if (HereDocUtils.isIdentifier(partition.getType())) {
            int hdLine = this.fDocument.getLineOfOffset(partition.getOffset());
            return this.findReparseStartForIdent(hdLine, category, first);
        }
        return this.findReparseStartForTerm(category, first, partition.getType());
    }

    private int findReparseStartForTerm(Position[] positions, int index, String termContentType) throws BadLocationException {
        TypedPosition ident = null;
        ListIterator<Position> iter = Arrays.asList(positions).listIterator(index);
        while (iter.hasPrevious()) {
            ident = (TypedPosition)iter.previous();
            if (!HereDocUtils.isIdentForTerm(termContentType, ident.getType())) continue;
            index = iter.nextIndex() + 1;
            break;
        }
        Assert.isNotNull(ident, (String)"unable to find line of a starting heredoc partition");
        int hdLine = this.fDocument.getLineOfOffset(ident.getOffset());
        return this.findReparseStartForIdent(hdLine, positions, index);
    }

    private int findReparseStartForIdent(int hdLine, Position[] positions, int index) throws BadLocationException {
        int pLine;
        int reparseStart = 0;
        ListIterator<Position> iter = Arrays.asList(positions).listIterator(index);
        TypedPosition pos = null;
        do {
            pos = (TypedPosition)iter.previous();
            pLine = this.fDocument.getLineOfOffset(pos.getOffset());
            if (!HereDocUtils.isIdentifier(pos.getType())) continue;
            reparseStart = pos.getOffset();
        } while (hdLine == pLine && iter.hasPrevious());
        return reparseStart;
    }

    protected void initialize() {
        this.fIsInitialized = true;
        super.initialize();
    }

    protected boolean isSupportedContentType(String contentType) {
        if (HereDocUtils.isHereDocContent(contentType)) {
            return true;
        }
        return super.isSupportedContentType(contentType);
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int offset = Math.min(this.fDeleteOffset, this.fStartOffset);
        int endOffset = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(offset, endOffset - offset);
    }

    private void rememberDeletedOffset(int offset) {
        this.fDeleteOffset = offset;
    }

    private void rememberRegion(int offset, int length) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = offset;
        } else if (offset < this.fStartOffset) {
            this.fStartOffset = offset;
        }
        int endOffset = offset + length;
        if (this.fEndOffset == -1) {
            this.fEndOffset = endOffset;
        } else if (endOffset > this.fEndOffset) {
            this.fEndOffset = endOffset;
        }
    }
}

