/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.IControlDecorationManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlDecorationManager
implements IControlDecorationManager {
    private Map<Control, ControlDecoration> decorations = new IdentityHashMap<Control, ControlDecoration>();

    @Override
    public void show(Control control, IStatus status) {
        ControlDecoration decoration = this.decorations.get(control);
        if (decoration == null) {
            decoration = new ControlDecoration(control, 16512);
            this.decorations.put(control, decoration);
        }
        Image image = this.getImageFor(status);
        if (decoration.getImage() != image) {
            Composite parent = control.getParent();
            if (parent.getLayout() instanceof GridLayout) {
                GridLayout layout = (GridLayout)parent.getLayout();
                if (image.getBounds().width > layout.horizontalSpacing) {
                    layout.horizontalSpacing = image.getBounds().width;
                    parent.layout();
                }
            }
            decoration.setImage(image);
        }
        decoration.setDescriptionText(status.getMessage());
        decoration.show();
    }

    protected Image getImageFor(IStatus status) {
        Image image = DLTKUIPlugin.getImageDescriptorRegistry().get(DLTKPluginImages.DESC_OVR_ERROR);
        return image;
    }

    @Override
    public void hide(Control control) {
        ControlDecoration decoration = this.decorations.get(control);
        if (decoration != null) {
            decoration.hide();
        }
    }

    public void dispose() {
        for (ControlDecoration decoration : this.decorations.values()) {
            decoration.hide();
            decoration.dispose();
        }
        this.decorations.clear();
    }

    @Override
    public void commit() {
    }

    public IControlDecorationManager beginReporting() {
        return new ControlDecorationManagerWorkingCopy(this);
    }

    private static class ControlDecorationManagerWorkingCopy
    implements IControlDecorationManager {
        private final ControlDecorationManager manager;
        private Map<Control, ControlDecoration> activeDecorations = new IdentityHashMap<Control, ControlDecoration>();

        public ControlDecorationManagerWorkingCopy(ControlDecorationManager manager) {
            this.manager = manager;
            this.activeDecorations.putAll(manager.decorations);
        }

        @Override
        public void commit() {
            if (!this.activeDecorations.isEmpty()) {
                for (Control control : this.activeDecorations.keySet()) {
                    this.manager.hide(control);
                }
                this.activeDecorations.clear();
            }
        }

        @Override
        public void hide(Control control) {
            this.activeDecorations.remove(control);
            this.manager.hide(control);
        }

        @Override
        public void show(Control control, IStatus status) {
            this.activeDecorations.remove(control);
            this.manager.show(control, status);
        }
    }
}

