/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.launching.IPathEquality;

public class PathEqualityUtils {
    public static synchronized IPathEquality getInstance() {
        IPathEquality compare = Platform.getOS().equals("win32") ? new Win32PathCompare() : new GenericPathCompare();
        return compare;
    }

    private static final class GenericPathCompare
    implements IPathEquality {
        private GenericPathCompare() {
        }

        @Override
        public boolean equals(IPath path1, IPath path2) {
            return path1.equals((Object)path2);
        }

        @Override
        public boolean isPrefixOf(IPath path, IPath anotherPath) {
            return path.isPrefixOf(anotherPath);
        }
    }

    private static final class Win32PathCompare
    implements IPathEquality {
        private Win32PathCompare() {
        }

        @Override
        public boolean equals(IPath path1, IPath path2) {
            return path1.removeTrailingSeparator().toOSString().equalsIgnoreCase(path2.removeTrailingSeparator().toOSString());
        }

        @Override
        public boolean isPrefixOf(IPath path, IPath anotherPath) {
            if (path.getDevice() == null ? anotherPath.getDevice() != null : !path.getDevice().equalsIgnoreCase(anotherPath.getDevice())) {
                return false;
            }
            if (path.isEmpty() || path.isRoot() && anotherPath.isAbsolute()) {
                return true;
            }
            int len = path.segmentCount();
            if (len > anotherPath.segmentCount()) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (!path.segment(i).equalsIgnoreCase(anotherPath.segment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

