/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.codeassist;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.codeassist.impl.Engine;
import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;

public abstract class ScriptCompletionEngine
extends Engine
implements ICompletionEngine {
    protected static final boolean DEBUG;
    protected static final boolean VERBOSE;
    protected IScriptProject scriptProject;
    protected CompletionRequestor requestor;
    protected int startPosition;
    protected int actualCompletionPosition;
    protected int endPosition;
    protected int offset;
    protected char[] fileName = null;
    protected boolean noProposal = true;
    protected CategorizedProblem problem = null;
    protected char[] source;

    static {
        VERBOSE = DEBUG = DLTKCore.DEBUG_COMPLETION;
    }

    public ScriptCompletionEngine() {
        super(null);
    }

    protected CompletionProposal createProposal(int kind, int completionOffset) {
        CompletionProposal proposal = CompletionProposal.create(kind, completionOffset - this.offset);
        return proposal;
    }

    protected void printDebug(CategorizedProblem error) {
        if (DEBUG) {
            System.out.print("COMPLETION - completionFailure(");
            System.out.print(error);
            System.out.println(")");
        }
    }

    protected void printDebug(CompletionProposal proposal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("COMPLETION - ");
        switch (proposal.getKind()) {
            case 1: {
                buffer.append("FIELD_REF");
                break;
            }
            case 2: {
                buffer.append("KEYWORD");
                break;
            }
            case 3: {
                buffer.append("LABEL_REF");
                break;
            }
            case 4: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 6: {
                buffer.append("METHOD_DECLARATION");
                break;
            }
            case 5: {
                buffer.append("METHOD_REF");
                break;
            }
            case 11: {
                buffer.append("PACKAGE_REF");
                break;
            }
            case 7: {
                buffer.append("TYPE_REF");
                break;
            }
            case 8: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 9: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 10: {
                buffer.append("METHOD_NAME_REFERENCE");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        if (VERBOSE) {
            buffer.append("{\n");
            buffer.append("\tCompletion[").append(proposal.getCompletion() == null ? "null".toCharArray() : proposal.getCompletion()).append("]\n");
            buffer.append("\tDeclarationKey[").append(proposal.getDeclarationKey() == null ? "null".toCharArray() : proposal.getDeclarationKey()).append("]\n");
            buffer.append("\tKey[").append(proposal.getKey() == null ? "null".toCharArray() : proposal.getKey()).append("]\n");
            buffer.append("\tName[").append(proposal.getName() == null ? "null".toCharArray() : proposal.getName()).append("]\n");
            buffer.append("\tCompletionLocation[").append(proposal.getCompletionLocation()).append("]\n");
            int start = proposal.getReplaceStart();
            int end = proposal.getReplaceEnd();
            buffer.append("\tReplaceStart[").append(start).append("]");
            buffer.append("-ReplaceEnd[").append(end).append("]\n");
            if (this.source != null) {
                buffer.append("\tReplacedText[").append(this.source, start, end - start).append("]\n");
            }
            buffer.append("\tTokenStart[").append(proposal.getTokenStart()).append("]");
            buffer.append("-TokenEnd[").append(proposal.getTokenEnd()).append("]\n");
            buffer.append("\tRelevance[").append(proposal.getRelevance()).append("]\n");
            buffer.append("}\n");
        } else if (proposal.getCompletion() != null) {
            buffer.append(' ').append('\"').append(proposal.getCompletion()).append('\"');
        }
        System.out.println(buffer.toString());
    }

    protected void setSourceRange(int start, int end) {
        this.setSourceRange(start, end, true);
    }

    protected void setSourceRange(int start, int end, boolean emptyTokenAdjstment) {
        int endOfEmptyToken;
        this.startPosition = start;
        this.endPosition = emptyTokenAdjstment ? ((endOfEmptyToken = this.getEndOfEmptyToken()) > end ? endOfEmptyToken : end) : end;
    }

    protected abstract int getEndOfEmptyToken();

    protected abstract String processMethodName(IMethod var1, String var2);

    protected abstract String processTypeName(IType var1, String var2);

    protected abstract String processFieldName(IField var1, String var2);

    public void findKeywords(char[] keyword, char[][] choices, boolean canCompleteEmptyToken) {
        if (choices == null || choices.length == 0) {
            return;
        }
        int length = keyword.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < choices.length) {
                if (length <= choices[i].length && CharOperation.prefixEquals(keyword, choices[i], false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(keyword, choices[i]);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(2)) {
                        CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
                        proposal.setName(choices[i]);
                        proposal.setCompletion(choices[i]);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void findLocalVariables(char[] token, char[][] choices, boolean canCompleteEmptyToken, boolean provideDollar) {
        int kind = 4;
        this.findElements(token, choices, canCompleteEmptyToken, provideDollar, kind, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    protected void findElements(char[] token, char[][] choices, boolean canCompleteEmptyToken, boolean provideDollar, int kind, Map parameterNames, Map proposalInfos) {
        if (choices == null || choices.length == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < choices.length) {
                char[] co = choices[i];
                if (!provideDollar && co.length > 1 && co[0] == '$') {
                    char[] co2 = new char[co.length - 1];
                    System.arraycopy(co, 1, co2, 0, co2.length);
                    co = co2;
                }
                if (length <= choices[i].length && CharOperation.prefixEquals(token, co, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, co);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        proposal.setName(co);
                        proposal.setCompletion(co);
                        proposal.setParameterNames((char[][])parameterNames.get(choices[i]));
                        Object proposalInfo = proposalInfos.get(choices[i]);
                        if (proposalInfo != null) {
                            proposal.extraInfo = proposalInfo;
                        }
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void findMethods(char[] token, boolean canCompleteEmptyToken, List methods, List methodNames) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                IMethod method = (IMethod)methods.get(i);
                String qname = (String)methodNames.get(i);
                char[] name = qname.toCharArray();
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(6)) {
                        String[] arguments;
                        CompletionProposal proposal;
                        block12: {
                            proposal = this.createProposal(6, this.actualCompletionPosition);
                            proposal.setModelElement(method);
                            arguments = null;
                            if (method != null) {
                                try {
                                    proposal.setFlags(method.getFlags());
                                    arguments = method.getParameters();
                                }
                                catch (ModelException e) {
                                    if (!DLTKCore.DEBUG) break block12;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (arguments != null && arguments.length > 0) {
                            char[][] args = new char[arguments.length][];
                            int j = 0;
                            while (j < arguments.length) {
                                args[j] = arguments[j].toCharArray();
                                ++j;
                            }
                            proposal.setParameterNames(args);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void findLocalMethods(char[] token, boolean canCompleteEmptyToken, List methods, List methodNames) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                MethodDeclaration method = (MethodDeclaration)methods.get(i);
                char[] name = ((String)methodNames.get(i)).toCharArray();
                if (length <= name.length && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(6)) {
                        CompletionProposal proposal = this.createProposal(6, this.actualCompletionPosition);
                        List arguments = method.getArguments();
                        if (arguments != null && arguments.size() > 0) {
                            char[][] args = new char[arguments.size()][];
                            int j = 0;
                            while (j < arguments.size()) {
                                args[j] = ((Argument)arguments.get(j)).getName().toCharArray();
                                ++j;
                            }
                            proposal.setParameterNames(args);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List methods) {
        this.findMethods(token, canCompleteEmptyToken, methods, 6);
    }

    public void findFields(char[] token, boolean canCompleteEmptyToken, List methods, String prefix) {
        this.findFields(token, canCompleteEmptyToken, methods, 1, prefix);
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List methods, int kind) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                IMethod method = (IMethod)methods.get(i);
                String qname = this.processMethodName(method, tok);
                char[] name = qname.toCharArray();
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        String[] arguments;
                        CompletionProposal proposal;
                        block14: {
                            block13: {
                                proposal = this.createProposal(kind, this.actualCompletionPosition);
                                proposal.setModelElement(method);
                                try {
                                    proposal.setFlags(method.getFlags());
                                }
                                catch (ModelException e1) {
                                    if (!DLTKCore.DEBUG) break block13;
                                    e1.printStackTrace();
                                }
                            }
                            arguments = null;
                            try {
                                arguments = method.getParameters();
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG) break block14;
                                e.printStackTrace();
                            }
                        }
                        if (arguments != null && arguments.length > 0) {
                            char[][] args = new char[arguments.length][];
                            int j = 0;
                            while (j < arguments.length) {
                                args[j] = arguments[j].toCharArray();
                                ++j;
                            }
                            proposal.setParameterNames(args);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void findFields(char[] token, boolean canCompleteEmptyToken, List fields, int kind, String prefix) {
        if (fields == null || fields.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < fields.size()) {
                IField field = (IField)fields.get(i);
                String qname = this.processFieldName(field, tok);
                char[] name = qname.toCharArray();
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        proposal.setModelElement(field);
                        proposal.setName(name);
                        proposal.setCompletion((String.valueOf(prefix) + qname).toCharArray());
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void findTypes(char[] token, boolean canCompleteEmptyToken, List types) {
        if (types == null || types.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < types.size()) {
                IType type = (IType)types.get(i);
                String qname = this.processTypeName(type, tok);
                char[] name = qname.toCharArray();
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(7)) {
                        CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
                        proposal.setModelElement(type);
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                        proposal.setRelevance(relevance);
                        this.requestor.accept(proposal);
                        if (DEBUG) {
                            this.printDebug(proposal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private int computeBaseRelevance() {
        return 0;
    }

    private int computeRelevanceForInterestingProposal() {
        return 5;
    }

    protected int computeRelevanceForCaseMatching(char[] token, char[] proposalName) {
        if (this.options.camelCaseMatch) {
            if (CharOperation.equals(token, proposalName, true)) {
                return 14;
            }
            if (CharOperation.prefixEquals(token, proposalName, true)) {
                return 10;
            }
            if (CharOperation.camelCaseMatch(token, proposalName)) {
                return 5;
            }
            if (CharOperation.equals(token, proposalName, false)) {
                return 4;
            }
        } else {
            if (CharOperation.prefixEquals(token, proposalName, true)) {
                if (CharOperation.equals(token, proposalName, true)) {
                    return 14;
                }
                return 10;
            }
            if (CharOperation.equals(token, proposalName, false)) {
                return 4;
            }
        }
        return 0;
    }

    protected int computeRelevanceForRestrictions(int accessRuleKind) {
        if (accessRuleKind == 0) {
            return 3;
        }
        return 0;
    }

    public void setEnvironment(ISearchableEnvironment environment) {
        this.nameEnvironment = environment;
        this.lookupEnvironment = new LookupEnvironment(this, this.nameEnvironment);
    }

    public void setOptions(Map options) {
    }

    public void setProject(IScriptProject project) {
        this.scriptProject = project;
    }

    public void setRequestor(CompletionRequestor requestor) {
        this.requestor = requestor;
    }
}

