/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.HashtableOfObject;
import org.eclipse.dltk.compiler.util.SimpleSetOfCharArray;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.util.Util;

public class MixinIndex
extends Index {
    private static final String HEADER = "MIXIN INDEX 0.1";
    private HashtableOfObject docNamesToKeys;
    private final String fileName;
    private boolean dirty;

    public MixinIndex(String fileName, String containerPath, boolean reuseFile) throws IOException {
        super(fileName, containerPath);
        this.fileName = fileName;
        this.dirty = false;
        if (reuseFile) {
            this.initialize(reuseFile);
        } else {
            this.save();
        }
    }

    public void addIndexEntry(char[] category, char[] key, String containerRelativePath) {
        this.dirty = true;
        Assert.isTrue((boolean)CharOperation.equals(category, IIndexConstants.MIXIN));
        this.addIndexEntry(key, containerRelativePath.toCharArray());
    }

    public void addDocumentName(String containerRelativePath) {
        this.addDocumentName(containerRelativePath.toCharArray());
    }

    private void addDocumentName(char[] containerRelativePath) {
        if (!this.docNamesToKeys.containsKey(containerRelativePath)) {
            this.docNamesToKeys.put(containerRelativePath, new SimpleSetOfCharArray(1));
        }
    }

    private void addIndexEntry(char[] key, char[] containerRelativePath) {
        SimpleSetOfCharArray names = (SimpleSetOfCharArray)this.docNamesToKeys.get(containerRelativePath);
        if (names == null) {
            names = new SimpleSetOfCharArray(1);
            this.docNamesToKeys.put(containerRelativePath, names);
        }
        names.add(key);
    }

    public String containerRelativePath(String documentPath) {
        int index = documentPath.indexOf("|");
        if (index == -1) {
            index = this.containerPath.length();
            if (documentPath.length() <= index) {
                throw new IllegalArgumentException("Document path " + documentPath + " must be relative to " + this.containerPath);
            }
        }
        return documentPath.substring(index + 1);
    }

    public File getIndexFile() {
        return new File(this.fileName);
    }

    public boolean hasChanged() {
        return this.dirty;
    }

    private static boolean isMixinCategory(char[][] categories) {
        int i = 0;
        while (i < categories.length) {
            if (CharOperation.equals(categories[i], IIndexConstants.MIXIN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public EntryResult[] query(char[][] categories, char[] key, int matchRule) throws IOException {
        if (!MixinIndex.isMixinCategory(categories)) {
            return new EntryResult[0];
        }
        HashtableOfObject results = new HashtableOfObject(10);
        this.performQuery(key, matchRule, results);
        EntryResult[] entryResults = new EntryResult[results.elementSize];
        int count = 0;
        Object[] values = results.valueTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            EntryResult result = (EntryResult)values[i];
            if (result != null) {
                entryResults[count++] = result;
            }
            ++i;
        }
        return entryResults;
    }

    private void performQuery(char[] key, int matchRule, HashtableOfObject results) {
        char[][] keyTable = this.docNamesToKeys.keyTable;
        int i = 0;
        while (i < keyTable.length) {
            SimpleSetOfCharArray keys;
            char[] docName = keyTable[i];
            if (docName != null && (keys = (SimpleSetOfCharArray)this.docNamesToKeys.get(docName)) != null) {
                int j = 0;
                while (j < keys.values.length) {
                    char[] k = keys.values[j];
                    if (k != null && Index.isMatch(key, k, matchRule)) {
                        EntryResult s = (EntryResult)results.get(k);
                        if (s == null) {
                            s = new EntryResult(k, null);
                            results.put(k, s);
                        }
                        s.addDocumentName(new String(docName));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static String[] extractKeysFromTable(HashtableOfObject table) {
        String[] documentNames = new String[table.elementSize];
        int count = 0;
        char[][] values = table.keyTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            char[] result = values[i];
            if (result != null) {
                documentNames[count++] = new String(result);
            }
            ++i;
        }
        return documentNames;
    }

    private static String[] extractKeysFromTable(HashtableOfObject table, char[] substring) {
        String[] documentNames = new String[table.elementSize];
        int count = 0;
        char[][] values = table.keyTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            char[] result = values[i];
            if (result != null && CharOperation.startsWith(result, substring)) {
                documentNames[count++] = new String(result);
            }
            ++i;
        }
        if (count != documentNames.length) {
            String[] result = new String[count];
            System.arraycopy(documentNames, 0, result, 0, count);
            documentNames = result;
        }
        return documentNames;
    }

    public String[] queryDocumentNames(String substring) throws IOException {
        if (substring == null) {
            return MixinIndex.extractKeysFromTable(this.docNamesToKeys);
        }
        return MixinIndex.extractKeysFromTable(this.docNamesToKeys, substring.toCharArray());
    }

    public void remove(String containerRelativePath) {
        this.dirty = true;
        this.docNamesToKeys.removeKey(containerRelativePath.toCharArray());
    }

    public void save() throws IOException {
        if (this.docNamesToKeys == null) {
            this.docNamesToKeys = new HashtableOfObject(0);
        }
        if (!this.hasChanged()) {
            return;
        }
        File f = this.getIndexFile();
        FileOutputStream fouts = new FileOutputStream(f, false);
        BufferedOutputStream bufout = new BufferedOutputStream(fouts, 2048);
        DataOutputStream stream = new DataOutputStream(bufout);
        int docNamesCount = this.docNamesToKeys.elementSize;
        Util.writeUTF(stream, HEADER.toCharArray());
        stream.writeInt(docNamesCount);
        int i = 0;
        while (i < this.docNamesToKeys.keyTable.length) {
            char[] docName = this.docNamesToKeys.keyTable[i];
            if (docName != null) {
                Util.writeUTF(stream, docName);
                SimpleSetOfCharArray wordSet = (SimpleSetOfCharArray)this.docNamesToKeys.get(docName);
                if (wordSet != null) {
                    stream.writeInt(wordSet.elementSize);
                    int j = 0;
                    while (j < wordSet.values.length) {
                        char[] word = wordSet.values[j];
                        if (word != null) {
                            Util.writeUTF(stream, word);
                        }
                        ++j;
                    }
                } else {
                    stream.writeInt(0);
                }
            }
            ++i;
        }
        bufout.close();
        stream.close();
        fouts.close();
        this.dirty = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(boolean reuseExistingFile) throws IOException {
        File indexFile;
        block19: {
            block18: {
                boolean successful = false;
                indexFile = this.getIndexFile();
                if (!indexFile.exists()) break block19;
                if (!reuseExistingFile) break block18;
                this.docNamesToKeys = new HashtableOfObject(0);
                try {
                    try {
                        this.monitor.enterRead();
                        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile), 2048));
                        char[] header = Util.readUTF(stream);
                        if (new String(header).equals(HEADER)) {
                            int documentsCount = stream.readInt();
                            int i = 0;
                            while (true) {
                                if (i >= documentsCount) {
                                    successful = true;
                                    break;
                                }
                                char[] docName = Util.readUTF(stream);
                                int wordsCount = stream.readInt();
                                if (wordsCount > 0) {
                                    int j = 0;
                                    while (j < wordsCount) {
                                        char[] word = Util.readUTF(stream);
                                        this.addIndexEntry(word, docName);
                                        ++j;
                                    }
                                } else {
                                    this.addDocumentName(docName);
                                }
                                ++i;
                            }
                        }
                        stream.close();
                    }
                    catch (FileNotFoundException e) {
                        if (DLTKCore.DEBUG_INDEX) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        if (DLTKCore.DEBUG_INDEX) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    this.monitor.exitRead();
                    throw throwable;
                }
                {
                    Object var12_16 = null;
                    this.monitor.exitRead();
                    if (!successful) break block18;
                    return;
                }
            }
            if (!indexFile.delete()) {
                if (DLTKCore.DEBUG_INDEX) {
                    System.out.println("initialize - Failed to delete mixin index " + this.fileName);
                }
                throw new IOException("Failed to delete mixin index " + this.fileName);
            }
        }
        if (indexFile.createNewFile()) {
            this.docNamesToKeys = new HashtableOfObject();
            this.save();
            this.dirty = false;
            return;
        }
        if (DLTKCore.DEBUG_INDEX) {
            System.out.println("initialize - Failed to create new index " + this.fileName);
        }
        throw new IOException("Failed to create new index " + this.fileName);
    }

    public void startQuery() {
    }

    public void stopQuery() {
    }

    public String toString() {
        return "Mixin Index for " + this.containerPath;
    }

    public boolean isRebuildable() {
        return false;
    }
}

