/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.itcl.internal.core.parser.IncrTclParseUtil;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclExInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodCallStatement;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodDeclaration;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.extensions.ICompletionExtension;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclCompletionEngine;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordArgumentOrFunctionArgument;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.TclCompletionParser;

public class IncrTclCompletionExtension
implements ICompletionExtension {
    private CompletionRequestor requestor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public boolean visit(Expression s, TclCompletionParser parser, int position) {
        ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
        if (s instanceof IncrTclMethodCallStatement) {
            IncrTclMethodCallStatement pcs = (IncrTclMethodCallStatement)s;
            exprs.add(pcs.getInstNameRef());
            exprs.add(pcs.getCallName());
            if (pcs.getArgs() != null) {
                exprs.addAll(pcs.getArgs().getChilds());
            }
            this.processArgumentCompletion((Statement)s, exprs, parser, position);
        }
        return false;
    }

    public boolean visit(Statement s, TclCompletionParser parser, int position) {
        return false;
    }

    private void processArgumentCompletion(Statement s, List exprs, TclCompletionParser parser, int position) {
        TclStatement statement = new TclStatement(exprs);
        statement.setStart(s.sourceStart());
        statement.setEnd(s.sourceEnd());
        ASTNode completionNode = null;
        int i = 0;
        while (i < exprs.size()) {
            ASTNode n = (ASTNode)exprs.get(i);
            if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                completionNode = n;
            }
            ++i;
        }
        String token = "";
        if (completionNode != null && completionNode instanceof SimpleReference) {
            token = ((SimpleReference)completionNode).getName();
        }
        String[] keywords = token == null ? parser.checkKeywords("", 1) : parser.checkKeywords(token, 1);
        if (completionNode != null) {
            CompletionOnKeywordArgumentOrFunctionArgument nde = new CompletionOnKeywordArgumentOrFunctionArgument(token, completionNode, statement, keywords);
            parser.setAssistNodeParent(TclParseUtil.getPrevParent((ModuleDeclaration)parser.getModule(), (ASTNode)s));
            throw new CompletionNodeFound((ASTNode)nde, null);
        }
        CompletionOnKeywordArgumentOrFunctionArgument nde = new CompletionOnKeywordArgumentOrFunctionArgument(token, statement, keywords, position);
        parser.setAssistNodeParent(TclParseUtil.getPrevParent((ModuleDeclaration)parser.getModule(), (ASTNode)s));
        throw new CompletionNodeFound((ASTNode)nde, null);
    }

    public void completeOnKeywordOrFunction(CompletionOnKeywordOrFunction key, ASTNode astNodeParent, TclCompletionEngine engine) {
        char[] token;
        HashSet methodNames;
        if (!engine.getRequestor().isIgnored(7)) {
            methodNames = new HashSet();
            token = key.getToken();
            token = engine.removeLastColonFromToken(token);
            this.findLocalIncrTclClasses(token, methodNames, astNodeParent, engine);
            this.findIncrTclClasses(token, methodNames, engine);
        }
        if (!engine.getRequestor().isIgnored(1)) {
            methodNames = new HashSet();
            token = key.getToken();
            token = engine.removeLastColonFromToken(token);
            this.findLocalIncrTclClassInstances(token, methodNames, astNodeParent, engine);
            this.findIncrTclClassInstances(token, methodNames, engine);
            ASTNode node = key.getInParent();
            if (node instanceof IncrTclMethodDeclaration) {
                engine.findKeywords(token, (char[][])new char[][]{"$this".toCharArray()}, true);
            }
        }
        if (!engine.getRequestor().isIgnored(5)) {
            char[] token2 = key.getToken();
            token2 = engine.removeLastColonFromToken(token2);
            this.findClassMethods(token2, astNodeParent, engine, true);
        }
    }

    private void findClassMethods(char[] token, ASTNode astNodeParent, TclCompletionEngine engine, boolean addTop) {
        TclResolver resolver = new TclResolver(engine.getSourceModule(), engine.getParser().getModule());
        ArrayList<IModelElement> methods = new ArrayList<IModelElement>();
        ArrayList<String> methodNames = new ArrayList<String>();
        String prefix = "";
        if (token.length > 0 && token[0] == ':') {
            prefix = "::";
        }
        if (astNodeParent instanceof IncrTclMethodDeclaration) {
            IncrTclMethodDeclaration decl = (IncrTclMethodDeclaration)astNodeParent;
            MethodDeclaration[] statements = ((TypeDeclaration)decl.getDeclaringType()).getMethods();
            int i = 0;
            while (i < statements.length) {
                block7: {
                    MethodDeclaration st = statements[i];
                    if (st instanceof IncrTclMethodDeclaration) {
                        IModelElement element = resolver.findModelElementFrom((ASTNode)st);
                        methods.add(element);
                        methodNames.add(element.getElementName());
                        if (addTop && element instanceof IMethod) {
                            IMethod m = (IMethod)element;
                            try {
                                methodNames.add(String.valueOf(prefix) + m.getTypeQualifiedName("::", false));
                                methods.add(element);
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG) break block7;
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        engine.findMethods(token, true, methods, methodNames);
    }

    private void findLocalIncrTclClasses(char[] token, Set methodNames, ASTNode astNodeParent, TclCompletionEngine engine) {
        ASTNode parent = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getParser().getModule(), (ASTNode)astNodeParent);
        HashSet classes = new HashSet();
        this.findIncrTclClassessIn(parent, classes, engine);
        engine.removeSameFrom(methodNames, classes, new String(token));
        engine.findTypes(token, true, engine.toList(classes));
        methodNames.addAll(classes);
    }

    private void findLocalIncrTclClassInstances(char[] token, Set methodNames, ASTNode astNodeParent, TclCompletionEngine engine) {
        ASTNode parent = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getParser().getModule(), (ASTNode)astNodeParent);
        HashSet classes = new HashSet();
        this.findIncrTclClassInstancesIn(parent, classes, engine);
        engine.removeSameFrom(methodNames, classes, new String(token));
        engine.findFields(token, true, engine.toList(classes), "");
        methodNames.addAll(classes);
    }

    private void findIncrTclClassessIn(ASTNode parent, Set classes, final TclCompletionEngine engine) {
        ArrayList result;
        block2: {
            result = new ArrayList();
            final TclResolver resolver = new TclResolver(engine.getSourceModule(), engine.getParser().getModule(), null);
            try {
                engine.getParser().getModule().traverse(new ASTVisitor(){

                    public boolean visit(TypeDeclaration type) {
                        if ((type.getModifiers() & 0x200000) != 0 && type.sourceStart() < engine.getActualCompletionPosition()) {
                            resolver.searchAddElementsTo(engine.getParser().getModule().getStatements(), (ASTNode)type, (IParent)engine.getSourceModule(), result);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        classes.addAll(result);
    }

    private void findIncrTclClassInstancesIn(ASTNode parent, Set classes, final TclCompletionEngine engine) {
        ArrayList result;
        block2: {
            result = new ArrayList();
            final TclResolver resolver = new TclResolver(engine.getSourceModule(), engine.getParser().getModule(), null);
            try {
                parent.traverse(new ASTVisitor(){

                    public boolean visit(Statement st) {
                        if (st instanceof IncrTclInstanceVariable) {
                            resolver.searchAddElementsTo(engine.getParser().getModule().getStatements(), (ASTNode)st, (IParent)engine.getSourceModule(), result);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        classes.addAll(result);
    }

    private void findIncrTclClassInstances(char[] token, Set methodNames, TclCompletionEngine engine) {
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        if (to.length() == 0) {
            return;
        }
        HashSet elements = new HashSet();
        elements.addAll(methodNames);
        this.findClassesInstanceFromMixin(elements, String.valueOf(to) + "*", engine);
        engine.removeSameFrom(methodNames, elements, to);
        engine.findFields(token, true, engine.toList(elements), "");
        methodNames.addAll(elements);
    }

    private void completionForInstanceVariableMethods(FieldDeclaration var, char[] token, Set methodNames, TclCompletionEngine engine) {
        FieldDeclaration ivar;
        String keyPrefix = null;
        if (var instanceof IncrTclInstanceVariable) {
            ivar = (IncrTclInstanceVariable)var;
            TypeDeclaration declaringType = ivar.getDeclaringType();
            keyPrefix = TclParseUtil.getElementFQN((ASTNode)declaringType, (String)"{", (ModuleDeclaration)engine.getParser().getModule());
            if (keyPrefix.startsWith("{")) {
                keyPrefix = keyPrefix.substring(1);
            }
        } else if (var instanceof IncrTclExInstanceVariable) {
            ivar = (IncrTclExInstanceVariable)var;
            String className = ivar.getDeclaringClassParameter().getClassName();
            if (className.startsWith("::")) {
                className = className.substring(2);
            }
            keyPrefix = className.replaceAll("::", "{");
        }
        HashSet methods = new HashSet();
        this.findClassesFromMixin(methods, keyPrefix, engine);
        HashSet<Object> result = new HashSet<Object>();
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            IModelElement e = (IModelElement)iterator.next();
            if (e instanceof IType) {
                try {
                    IMethod[] ms = ((IType)e).getMethods();
                    int i = 0;
                    while (i < ms.length) {
                        if (Flags.isPublic((int)ms[i].getFlags()) || this.requestor == null || !this.requestor.isIgnored(16)) {
                            result.add(ms[i]);
                        }
                        ++i;
                    }
                }
                catch (ModelException e1) {
                    if (!DLTKCore.DEBUG) continue;
                    e1.printStackTrace();
                }
                continue;
            }
            if (!(e instanceof IMethod)) continue;
            result.add(e);
        }
        this.findMethodsShortName(token, result, methodNames, engine);
    }

    private void completeClassMethods(String name, char[] cs, Set methodNames, TclCompletionEngine engine) {
        HashSet completions = new HashSet();
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        this.findClassesFromMixin(completions, name, engine);
        if (completions.size() >= 1) {
            HashSet methods = new HashSet();
            methods.addAll(methodNames);
            this.findProcsFromMixin(methods, String.valueOf(name) + "::*", engine);
            methods.removeAll(methodNames);
            this.findMethodsShortName(cs, methods, methodNames, engine);
        }
    }

    private void addKeywords(char[] cs, String[] keywords, Set methodNames, TclCompletionEngine engine) {
        ArrayList<String> k = new ArrayList<String>();
        String token = new String(cs);
        int i = 0;
        while (i < keywords.length) {
            String kkw = keywords[i];
            if (kkw.startsWith(token) && !methodNames.contains(kkw)) {
                k.add(kkw);
                methodNames.add(kkw);
            }
            ++i;
        }
        String[] kw = k.toArray(new String[k.size()]);
        char[][] choices = new char[kw.length][];
        int i2 = 0;
        while (i2 < kw.length) {
            choices[i2] = kw[i2].toCharArray();
            ++i2;
        }
        engine.findKeywords(cs, (char[][])choices, true);
    }

    private void findMethodsShortName(char[] cs, Set methods, Set allMethods, TclCompletionEngine engine) {
        List methodsList = engine.toList(methods);
        ArrayList<String> methodNames = new ArrayList<String>();
        Iterator iterator = methodsList.iterator();
        while (iterator.hasNext()) {
            IMethod method = (IMethod)iterator.next();
            String methodName = method.getElementName();
            if (methodNames.contains(methodName)) continue;
            methodNames.add(methodName);
            allMethods.add(methodName);
        }
        engine.findMethods(cs, true, methodsList, methodNames);
    }

    protected void findProcsFromMixin(Set methods, String tok, TclCompletionEngine engine) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclProc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        engine.findMixinTclElement(methods, tok, (Class)clazz);
    }

    protected void findInstProcsFromMixin(Set methods, String tok, TclCompletionEngine engine) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclInstProc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        engine.findMixinTclElement(methods, tok, (Class)clazz);
    }

    private void findIncrTclClasses(char[] token, Set methodNames, TclCompletionEngine engine) {
        String to_ = new String(token);
        String to = to_;
        if (to.startsWith("::")) {
            to = to.substring(2);
        }
        if (to.length() == 0) {
            return;
        }
        HashSet methods = new HashSet();
        methods.addAll(methodNames);
        this.findClassesFromMixin(methods, String.valueOf(to) + "*", engine);
        methods.removeAll(methodNames);
        engine.removeSameFrom(methodNames, methods, to_);
        engine.findTypes(token, true, engine.toList(methods));
    }

    protected void findClassesFromMixin(Set completions, String tok, TclCompletionEngine engine) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        engine.findMixinTclElement(completions, tok, (Class)clazz);
    }

    protected void findClassesInstanceFromMixin(Set completions, String tok, TclCompletionEngine engine) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClassInstance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        engine.findMixinTclElement(completions, tok, (Class)clazz);
    }

    private FieldDeclaration searchFieldFromMixin(String name, TclCompletionEngine engine) {
        return null;
    }

    public void completeOnKeywordArgumentsOne(String name, char[] token, CompletionOnKeywordArgumentOrFunctionArgument compl, Set methodNames, TclStatement st, TclCompletionEngine engine) {
        this.completeClassMethods(name, token, methodNames, engine);
        FieldDeclaration var = IncrTclParseUtil.findInstanceVariableDeclarationFrom(engine.getParser().getModule(), TclParseUtil.getScopeParent((ModuleDeclaration)engine.getParser().getModule(), (ASTNode)st), name);
        if (var == null) {
            var = this.searchFieldFromMixin(name, engine);
        }
        if (var != null) {
            this.completionForInstanceVariableMethods(var, token, methodNames, engine);
        }
        if ("$this".equals(name) && compl.argumentIndex() == 1) {
            ASTNode inNode = TclParseUtil.getScopeParent((ModuleDeclaration)engine.getParser().getModule(), (ASTNode)st);
            this.findClassMethods(token, inNode, engine, false);
        }
    }

    public void setRequestor(CompletionRequestor requestor) {
        this.requestor = requestor;
    }

    public void completeOnVariables(CompletionOnVariable astNode, TclCompletionEngine engine) {
        ASTNode inNode = astNode.getInNode();
        if (inNode instanceof IncrTclMethodDeclaration) {
            engine.findKeywords(astNode.getToken(), (char[][])new char[][]{"$this".toCharArray()}, false);
        }
    }
}

