/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.BaseFunction;
import com.xored.org.mozilla.javascript.Context;
import com.xored.org.mozilla.javascript.Function;
import com.xored.org.mozilla.javascript.FunctionObject;
import com.xored.org.mozilla.javascript.Kit;
import com.xored.org.mozilla.javascript.MemberBox;
import com.xored.org.mozilla.javascript.ObjToIntMap;
import com.xored.org.mozilla.javascript.ScriptRuntime;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.Wrapper;
import com.xored.org.mozilla.javascript.debug.DebuggableObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private volatile transient Hashtable associatedValues;
    static /* synthetic */ Class class$0;

    static void checkValidAttributes(int attributes) {
        if ((attributes & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
    }

    public abstract String getClassName();

    public boolean has(String name, Scriptable start) {
        return this.getNamedSlot(name) != null;
    }

    public boolean has(int index, Scriptable start) {
        return this.getSlot(null, index) != null;
    }

    public Object get(String name, Scriptable start) {
        Slot slot = this.getNamedSlot(name);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            if (gslot.getter != null) {
                return this.getByGetter(gslot, start);
            }
        }
        return slot.value;
    }

    public Object get(int index, Scriptable start) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String name, Scriptable start, Object value) {
        int hash;
        Slot slot = this.lastAccess;
        if ((name != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(name, hash = name.hashCode())) == null) {
            if (start != this) {
                start.put(name, start, value);
                return;
            }
            slot = this.addSlot(name, hash, null);
        }
        if (start == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", name);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            if (gslot.setter != null) {
                this.setBySetter(gslot, start, value);
            }
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(name, start, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            if (start != this) {
                start.put(index, start, value);
                return;
            }
            slot = this.addSlot(null, index, null);
        }
        if (start == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", Integer.toString(index));
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(index, start, value);
        }
    }

    public void delete(String name) {
        this.removeSlot(name, name.hashCode());
    }

    public void delete(int index) {
        this.removeSlot(null, index);
    }

    public final int getAttributes(String name, Scriptable start) {
        return this.getAttributes(name);
    }

    public final int getAttributes(int index, Scriptable start) {
        return this.getAttributes(index);
    }

    public final void setAttributes(String name, Scriptable start, int attributes) {
        this.setAttributes(name, attributes);
    }

    public void setAttributes(int index, Scriptable start, int attributes) {
        this.setAttributes(index, attributes);
    }

    public int getAttributes(String name) {
        Slot slot = this.getNamedSlot(name);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", name);
        }
        return slot.attributes;
    }

    public int getAttributes(int index) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(index));
        }
        return slot.attributes;
    }

    public void setAttributes(String name, int attributes) {
        ScriptableObject.checkValidAttributes(attributes);
        Slot slot = this.getNamedSlot(name);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", name);
        }
        slot.attributes = (short)attributes;
    }

    public void setAttributes(int index, int attributes) {
        ScriptableObject.checkValidAttributes(attributes);
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(index));
        }
        slot.attributes = (short)attributes;
    }

    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    public void setPrototype(Scriptable m) {
        this.prototypeObject = m;
    }

    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    public void setParentScope(Scriptable m) {
        this.parentScopeObject = m;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class typeHint) {
        Context cx = null;
        int i = 0;
        while (i < 2) {
            Object[] args;
            String methodName;
            boolean tryToString;
            if (typeHint == ScriptRuntime.StringClass) {
                tryToString = i == 0;
            } else {
                boolean bl = tryToString = i == 1;
            }
            if (tryToString) {
                methodName = "toString";
                args = ScriptRuntime.emptyArgs;
            } else {
                String hint;
                methodName = "valueOf";
                args = new Object[1];
                if (typeHint == null) {
                    hint = "undefined";
                } else if (typeHint == ScriptRuntime.StringClass) {
                    hint = "string";
                } else if (typeHint == ScriptRuntime.ScriptableClass) {
                    hint = "object";
                } else if (typeHint == ScriptRuntime.FunctionClass) {
                    hint = "function";
                } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                    hint = "boolean";
                } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                    hint = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                }
                args[0] = hint;
            }
            Object v = ScriptableObject.getProperty((Scriptable)this, methodName);
            if (v instanceof Function) {
                Function fun = (Function)v;
                if (cx == null) {
                    cx = Context.getContext();
                }
                if ((v = fun.call(cx, fun.getParentScope(), this, args)) != null) {
                    Object u;
                    if (!(v instanceof Scriptable)) {
                        return v;
                    }
                    if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                        return v;
                    }
                    if (tryToString && v instanceof Wrapper && (u = ((Wrapper)v).unwrap()) instanceof String) {
                        return u;
                    }
                }
            }
            ++i;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeError1("msg.default.value", arg);
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    protected Object equivalentValues(Object value) {
        return this == value ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static void defineClass(Scriptable scope, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, false, false);
    }

    public static void defineClass(Scriptable scope, Class clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz, sealed, false);
    }

    public static String defineClass(Scriptable scope, Class clazz, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        String name;
        Class superClass;
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("init")) {
                Class<?>[] parmTypes = method.getParameterTypes();
                if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                    method.invoke(null, args);
                    return null;
                }
                if (parmTypes.length == 1 && parmTypes[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{scope};
                    method.invoke(null, args);
                    return null;
                }
            }
            ++i;
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        int i2 = 0;
        while (i2 < ctors.length) {
            if (ctors[i2].getParameterTypes().length == 0) {
                protoCtor = ctors[i2];
                break;
            }
            ++i2;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        String className = proto.getClassName();
        Scriptable superProto = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz.getSuperclass()) && (name = ScriptableObject.defineClass(scope, superClass, sealed, mapInheritance)) != null) {
            superProto = ScriptableObject.getClassPrototype(scope, name);
        }
        if (superProto == null) {
            superProto = ScriptableObject.getObjectPrototype(scope);
        }
        proto.setPrototype(superProto);
        Executable ctorMember = FunctionObject.findSingleMethod(methods, "jsConstructor");
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (ctors[0].getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (ctors[1].getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((ctor = new FunctionObject(className, ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.addAsConstructor(scope, proto);
        Method finishInit = null;
        int i3 = 0;
        while (i3 < methods.length) {
            block36: {
                String prefix;
                String name2;
                block39: {
                    block41: {
                        block40: {
                            block38: {
                                block37: {
                                    Class<?>[] parmTypes;
                                    if (methods[i3] == ctorMember) break block36;
                                    name2 = methods[i3].getName();
                                    if (!name2.equals("finishInit") || (parmTypes = methods[i3].getParameterTypes()).length != 3 || parmTypes[0] != ScriptRuntime.ScriptableClass) break block37;
                                    Class<?> clazz2 = parmTypes[1];
                                    Class<?> clazz3 = class$0;
                                    if (clazz3 == null) {
                                        try {
                                            clazz3 = Class.forName("com.xored.org.mozilla.javascript.FunctionObject");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz2 != clazz3 || parmTypes[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methods[i3].getModifiers())) break block37;
                                    finishInit = methods[i3];
                                    break block36;
                                }
                                if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) break block36;
                                prefix = null;
                                if (!name2.startsWith("jsFunction_")) break block38;
                                prefix = "jsFunction_";
                                break block39;
                            }
                            if (!name2.startsWith("jsStaticFunction_")) break block40;
                            prefix = "jsStaticFunction_";
                            if (!Modifier.isStatic(methods[i3].getModifiers())) {
                                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
                            }
                            break block39;
                        }
                        if (!name2.startsWith("jsGet_")) break block41;
                        prefix = "jsGet_";
                        break block39;
                    }
                    if (!name2.startsWith("jsSet_")) break block36;
                    prefix = "jsSet_";
                }
                name2 = name2.substring(prefix.length());
                if (prefix != "jsSet_") {
                    if (prefix == "jsGet_") {
                        if (!(proto instanceof ScriptableObject)) {
                            throw Context.reportRuntimeError2("msg.extend.scriptable", proto.getClass().toString(), name2);
                        }
                        Method setter = FunctionObject.findSingleMethod(methods, "jsSet_" + name2);
                        int attr = 6 | (setter != null ? 0 : 1);
                        ((ScriptableObject)proto).defineProperty(name2, null, methods[i3], setter, attr);
                    } else {
                        FunctionObject f = new FunctionObject(name2, methods[i3], proto);
                        if (f.isVarArgsConstructor()) {
                            throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
                        }
                        Scriptable dest = prefix == "jsStaticFunction_" ? ctor : proto;
                        ScriptableObject.defineProperty(dest, name2, f, 2);
                        if (sealed) {
                            f.sealObject();
                        }
                    }
                }
            }
            ++i3;
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
        return className;
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.put(propertyName, (Scriptable)this, value);
        this.setAttributes(propertyName, attributes);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value, attributes);
    }

    public void defineProperty(String propertyName, Class clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = FunctionObject.getMethodList(clazz);
        Method getter = FunctionObject.findSingleMethod(methods, getterName);
        Method setter = FunctionObject.findSingleMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter == null ? null : setter, attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) {
        Class<?>[] parmTypes;
        if (delegateTo == null && Modifier.isStatic(getter.getModifiers())) {
            delegateTo = HAS_STATIC_ACCESSORS;
        }
        if ((parmTypes = getter.getParameterTypes()).length != 0) {
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableObjectClass) {
                throw Context.reportRuntimeError1("msg.bad.getter.parms", getter.toString());
            }
        } else if (delegateTo != null) {
            throw Context.reportRuntimeError1("msg.obj.getter.parms", getter.toString());
        }
        if (setter != null) {
            Class<?> setterType;
            int setterTypeTag;
            if (delegateTo == HAS_STATIC_ACCESSORS != Modifier.isStatic(setter.getModifiers())) {
                throw Context.reportRuntimeError0("msg.getter.static");
            }
            parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 2) {
                if (parmTypes[0] != ScriptRuntime.ScriptableObjectClass) {
                    throw Context.reportRuntimeError0("msg.setter2.parms");
                }
                if (delegateTo == null) {
                    throw Context.reportRuntimeError1("msg.setter1.parms", setter.toString());
                }
            } else if (parmTypes.length == 1) {
                if (delegateTo != null) {
                    throw Context.reportRuntimeError1("msg.setter2.expected", setter.toString());
                }
            } else {
                throw Context.reportRuntimeError0("msg.setter.parms");
            }
            if ((setterTypeTag = FunctionObject.getTypeTag(setterType = parmTypes[parmTypes.length - 1])) == 0) {
                throw Context.reportRuntimeError2("msg.setter2.expected", setterType.getName(), setter.toString());
            }
        }
        GetterSlot gslot = new GetterSlot();
        gslot.delegateTo = delegateTo;
        gslot.getter = new MemberBox(getter);
        if (setter != null) {
            gslot.setter = new MemberBox(setter);
        }
        gslot.attributes = (short)attributes;
        Slot inserted = this.addSlot(propertyName, propertyName.hashCode(), gslot);
        if (inserted != gslot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] names, Class clazz, int attributes) {
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Method m = FunctionObject.findSingleMethod(methods, name);
            if (m == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m, this);
            this.defineProperty(name, f, attributes);
            ++i;
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty();
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get("prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return ScriptableObject.getBase(obj, name) != null;
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return ScriptableObject.getBase(obj, index) != null;
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = obj.getIds();
        ObjToIntMap map = null;
        while ((obj = obj.getPrototype()) != null) {
            int i;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (map == null) {
                if (result.length == 0) {
                    result = ids;
                    continue;
                }
                map = new ObjToIntMap(result.length + ids.length);
                i = 0;
                while (i != result.length) {
                    map.intern(result[i]);
                    ++i;
                }
                result = null;
            }
            i = 0;
            while (i != ids.length) {
                map.intern(ids[i]);
                ++i;
            }
        }
        if (map != null) {
            result = map.getKeys();
        }
        return result;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) {
        return ScriptableObject.callMethod(null, obj, methodName, args);
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object[] args) {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.notFunctionError(obj, methodName);
        }
        Function fun = (Function)funObj;
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        if (cx != null) {
            return fun.call(cx, scope, obj, args);
        }
        return Context.call(null, fun, scope, obj, args);
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        while (!obj.has(name, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        while (!obj.has(index, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key) {
        Hashtable h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public static Object getTopScopeValue(Scriptable scope, Object key) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value;
            if (!(scope instanceof ScriptableObject) || (value = (so = (ScriptableObject)scope).getAssociatedValue(key)) == null) continue;
            return value;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object associateValue(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Hashtable h = this.associatedValues;
        if (h == null) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                h = this.associatedValues;
                if (h == null) {
                    this.associatedValues = h = new Hashtable();
                }
            }
        }
        return Kit.initHash(h, key, value);
    }

    private Object getByGetter(GetterSlot slot, Scriptable start) {
        Object[] args;
        Object getterThis;
        if (slot.delegateTo == null) {
            if (start != this) {
                Class clazz = slot.getter.getDeclaringClass();
                while (!clazz.isInstance(start)) {
                    if ((start = start.getPrototype()) == this) break;
                    if (start != null) continue;
                    start = this;
                    break;
                }
            }
            getterThis = start;
            args = ScriptRuntime.emptyArgs;
        } else {
            getterThis = slot.delegateTo;
            args = new Object[]{this};
        }
        return slot.getter.invoke(getterThis, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBySetter(GetterSlot slot, Scriptable start, Object value) {
        Object[] args;
        Object setterThis;
        if (!(start == this || slot.delegateTo == null && slot.setter.getDeclaringClass().isInstance(start))) {
            start.put(slot.stringKey, start, value);
            return;
        }
        Context cx = Context.getContext();
        Class[] pTypes = slot.setter.argTypes;
        Class desired = pTypes[pTypes.length - 1];
        int tag = FunctionObject.getTypeTag(desired);
        Object actualArg = FunctionObject.convertArg(cx, start, value, tag);
        if (slot.delegateTo == null) {
            setterThis = start;
            args = new Object[]{actualArg};
        } else {
            if (start != this) {
                Kit.codeBug();
            }
            setterThis = slot.delegateTo;
            args = new Object[]{this, actualArg};
        }
        if (((ScriptableObject)start).isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", slot.stringKey);
        }
        Object setterResult = slot.setter.invoke(setterThis, args);
        if (slot.setter.method().getReturnType() != Void.TYPE) {
            Slot replacement = new Slot();
            replacement.intKey = slot.intKey;
            replacement.stringKey = slot.stringKey;
            replacement.attributes = slot.attributes;
            replacement.value = setterResult;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int i = ScriptableObject.getSlotPosition(this.slots, slot.stringKey, slot.intKey);
                if (i >= 0 && this.slots[i] == slot) {
                    this.slots[i] = replacement;
                    this.lastAccess = replacement;
                }
            }
        }
    }

    private Slot getNamedSlot(String name) {
        Slot slot = this.lastAccess;
        if (name == slot.stringKey && slot.wasDeleted == 0) {
            return slot;
        }
        Slot[] slots = this.slots;
        int hash = name.hashCode();
        int i = ScriptableObject.getSlotPosition(slots, name, hash);
        if (i < 0) {
            return null;
        }
        slot = slots[i];
        slot.stringKey = name;
        this.lastAccess = slot;
        return slot;
    }

    private Slot getSlot(String id, int index) {
        Slot[] slots = this.slots;
        int i = ScriptableObject.getSlotPosition(slots, id, index);
        return i < 0 ? null : slots[i];
    }

    private static int getSlotPosition(Slot[] slots, String id, int index) {
        if (slots != null) {
            Slot slot;
            int start;
            int i = start = (index & Integer.MAX_VALUE) % slots.length;
            while ((slot = slots[i]) != null) {
                if (slot != REMOVED && slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                    return i;
                }
                if (++i == slots.length) {
                    i = 0;
                }
                if (i != start) continue;
            }
        }
        return -1;
    }

    private synchronized Slot addSlot(String id, int index, Slot newSlot) {
        if (this.isSealed()) {
            String str = id != null ? id : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.add.sealed", str);
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(id, index, newSlot);
    }

    private Slot addSlotImpl(String id, int index, Slot newSlot) {
        int start;
        int i = start = (index & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[i]) == null || slot == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(id, index, newSlot);
                }
                slot = newSlot == null ? new Slot() : newSlot;
                slot.stringKey = id;
                slot.intKey = index;
                this.slots[i] = slot;
                ++this.count;
                return slot;
            }
            if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != this.slots.length) continue;
            i = 0;
        } while (i != start);
        throw new IllegalStateException();
    }

    private synchronized void removeSlot(String name, int index) {
        if (this.isSealed()) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.remove.sealed", str);
        }
        int i = ScriptableObject.getSlotPosition(this.slots, name, index);
        if (i >= 0) {
            Slot slot = this.slots[i];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
                --this.count;
                this.slots[i] = this.count != 0 ? REMOVED : null;
            }
        }
    }

    private void grow() {
        Slot[] newSlots = new Slot[this.slots.length * 2 + 1];
        int j = this.slots.length - 1;
        while (j >= 0) {
            Slot slot = this.slots[j];
            if (slot != null && slot != REMOVED) {
                int k = (slot.intKey & Integer.MAX_VALUE) % newSlots.length;
                while (newSlots[k] != null) {
                    if (++k != newSlots.length) continue;
                    k = 0;
                }
                newSlots[k] = slot;
            }
            --j;
        }
        this.slots = newSlots;
    }

    Object[] getIds(boolean getAll) {
        Slot[] s = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s == null) {
            return a;
        }
        int c = 0;
        int i = 0;
        while (i < s.length) {
            Slot slot = s[i];
            if (slot != null && slot != REMOVED && (getAll || (slot.attributes & 2) == 0)) {
                if (c == 0) {
                    a = new Object[s.length - i];
                }
                a[c++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
            }
            ++i;
        }
        if (c == a.length) {
            return a;
        }
        Object[] result = new Object[c];
        System.arraycopy(a, 0, result, 0, c);
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Slot[] s;
        out.defaultWriteObject();
        int N = this.count;
        if (N < 0) {
            N = -1 - this.count;
        }
        if ((s = this.slots) == null) {
            if (N != 0) {
                Kit.codeBug();
            }
            out.writeInt(0);
        } else {
            out.writeInt(s.length);
            int i = 0;
            while (N != 0) {
                Slot slot = s[i];
                if (slot != null && slot != REMOVED) {
                    --N;
                    out.writeObject(slot);
                }
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastAccess = REMOVED;
        int capacity = in.readInt();
        if (capacity != 0) {
            this.slots = new Slot[capacity];
            int N = this.count;
            boolean wasSealed = false;
            if (N < 0) {
                N = -1 - N;
                wasSealed = true;
            }
            this.count = 0;
            int i = 0;
            while (i != N) {
                Slot s = (Slot)in.readObject();
                this.addSlotImpl(s.stringKey, s.intKey, s);
                ++i;
            }
            if (wasSealed) {
                this.count = -1 - this.count;
            }
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object delegateTo;
        MemberBox getter;
        MemberBox setter;

        private GetterSlot() {
            super(null, null);
        }
    }

    private static class Slot
    implements Serializable {
        static final long serialVersionUID = -3539051633409902634L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }

        /* synthetic */ Slot(Slot slot, Slot slot2) {
            this();
        }
    }
}

