/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.javascript.parser.LineTracker;

public class Reporter
extends LineTracker
implements IProblemReporter {
    private final IProblemReporter problemReporter;
    private int id;
    private String message;
    private int line;
    private int start;
    private int end;
    private Severity severity;

    public Reporter(ISourceLineTracker lineTracker, IProblemReporter problemReporter) {
        super(lineTracker);
        this.problemReporter = problemReporter;
        this.reset();
    }

    private void reset() {
        this.severity = Severity.WARNING;
        this.id = 0;
        this.message = null;
        this.line = -1;
        this.start = -1;
        this.end = -1;
    }

    public void report() {
        if (this.problemReporter != null && this.message != null) {
            this.problemReporter.reportProblem(this.createProblem());
        }
        this.reset();
    }

    private IProblem createProblem() {
        if (this.line == -1 && this.start != -1) {
            this.line = this.getLineNumberOfOffset(this.start);
        }
        return new DefaultProblem(this.message, this.id, null, this.severity == Severity.ERROR ? 1 : 0, this.start, this.end, this.line);
    }

    public void setMessage(int id, String message) {
        this.id = id;
        this.message = message;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public void setRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public void reportProblem(IProblem problem) {
        if (this.problemReporter != null) {
            this.problemReporter.reportProblem(problem);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void reportProblem(int id, String message, int start, int end) {
        this.reportProblem((IProblem)new DefaultProblem(message, id, null, 0, start, end, this.getLineNumberOfOffset(start)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR;

    }
}

