/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.dltk.javascript.parser.JSTokenSource;
import org.eclipse.dltk.javascript.parser.JSTokenStream;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.utils.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTokenStream
implements TokenStream,
JSTokenStream {
    private static final boolean DEBUG = false;
    private final JSTokenSource tokenSource;
    private List<Token> tokens = new ArrayList<Token>(500);
    private IntList offsets = new IntList(500);
    private IntList modes = new IntList(500);
    private int currentMode = 0;
    private int channel = 0;
    private int lastMarker;
    private int p = 0;
    private boolean pValid = false;
    private boolean endOfStream = false;

    public DynamicTokenStream(JSTokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    public DynamicTokenStream(JSTokenSource tokenSource, int channel) {
        this(tokenSource);
        this.channel = channel;
    }

    private final boolean fetchToken() {
        Token t = this.tokenSource.nextToken();
        if (t != Token.EOF_TOKEN) {
            int index = this.tokens.size();
            t.setTokenIndex(index);
            this.tokens.add(t);
            int offset = t.getText().length();
            if (this.offsets.size() != 0) {
                offset += this.offsets.get(this.offsets.size() - 1);
            }
            this.offsets.add(offset);
            this.modes.add(this.currentMode);
            return true;
        }
        return false;
    }

    protected void fill(int n) {
        if (this.endOfStream) {
            return;
        }
        int i = this.tokens.size();
        while (i <= n) {
            if (!this.fetchToken()) {
                this.endOfStream = true;
                break;
            }
            ++i;
        }
    }

    private void init() {
        if (!this.pValid) {
            this.p = this.skipOffTokenChannels(this.p);
            this.pValid = true;
        }
    }

    private void loadAll() {
        if (!this.endOfStream) {
            while (this.fetchToken()) {
            }
            this.endOfStream = true;
        }
    }

    public void consume() {
        assert (this.pValid);
        if (!this.endOfStream) {
            this.fill(this.p + 1);
        }
        if (this.p < this.tokens.size()) {
            ++this.p;
            this.p = this.skipOffTokenChannels(this.p);
            this.pValid = true;
        }
    }

    protected int skipOffTokenChannels(int i) {
        while (true) {
            if (!this.endOfStream) {
                this.fill(i);
            }
            if (i >= this.tokens.size()) {
                return i;
            }
            if (this.tokens.get(i).getChannel() == this.channel) {
                return i;
            }
            ++i;
        }
    }

    protected int skipOffTokenChannelsReverse(int i) {
        while (i >= 0 && this.tokens.get(i).getChannel() != this.channel) {
            --i;
        }
        return i;
    }

    @Override
    public List<Token> getTokens() {
        this.loadAll();
        return this.tokens;
    }

    public Token LT(int k) {
        if (k == 0) {
            return null;
        }
        this.init();
        if (k < 0) {
            return this.LB(-k);
        }
        this.fill(this.p + k - 1);
        if (this.p + k - 1 >= this.tokens.size()) {
            return Token.EOF_TOKEN;
        }
        int i = this.p;
        while (--k > 0) {
            i = this.skipOffTokenChannels(i + 1);
        }
        if (i >= this.tokens.size()) {
            return Token.EOF_TOKEN;
        }
        return this.tokens.get(i);
    }

    protected Token LB(int k) {
        assert (k != 0);
        if (this.p < k) {
            return null;
        }
        int i = this.p;
        while (--k >= 0) {
            i = this.skipOffTokenChannelsReverse(i - 1);
        }
        if (i < 0) {
            return null;
        }
        return this.tokens.get(i);
    }

    public Token get(int i) {
        this.fill(i);
        return i < this.tokens.size() ? this.tokens.get(i) : null;
    }

    public int LA(int i) {
        return this.LT(i).getType();
    }

    public int mark() {
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public int size() {
        this.loadAll();
        return this.tokens.size();
    }

    public int index() {
        assert (this.pValid);
        return this.p;
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int index) {
        this.fill(index);
        this.p = index;
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public String toString() {
        this.loadAll();
        return this.toString(0, this.tokens.size() - 1);
    }

    public String toString(int start, int stop) {
        if (start < 0 || stop < 0) {
            return null;
        }
        this.fill(stop);
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        StringBuilder buf = new StringBuilder();
        int i = start;
        while (i <= stop) {
            Token t = this.tokens.get(i);
            buf.append(t.getText());
            ++i;
        }
        return buf.toString();
    }

    public String toString(Token start, Token stop) {
        if (start != null && stop != null) {
            return this.toString(start.getTokenIndex(), stop.getTokenIndex());
        }
        return null;
    }

    @Override
    public int getMode() {
        return this.currentMode;
    }

    @Override
    public void setMode(int value) {
        if (value == this.currentMode) {
            return;
        }
        this.currentMode = value;
        this.tokenSource.setMode(value);
        if (this.p < this.tokens.size()) {
            this.pValid = false;
            this.endOfStream = false;
            int i = this.tokens.size();
            while (--i >= this.p) {
                this.tokens.remove(i);
            }
            assert (this.p == this.tokens.size());
            this.offsets.setSize(this.p);
            this.modes.setSize(this.p);
            assert (this.offsets.size() == this.tokens.size());
            this.tokenSource.seek(this.offsets.size() == 0 ? 0 : this.offsets.get(this.offsets.size() - 1));
        }
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.tokenSource.setReporter(reporter);
    }
}

