/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class TypeHistoryManager
extends AbstractContextListener {
    public void contextActivated(IInteractionContext context) {
        this.clearTypeHistory();
        ListIterator it = context.getInteresting().listIterator();
        while (it.hasNext()) {
            IInteractionElement node = (IInteractionElement)it.next();
            this.updateTypeHistory(node, true);
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        IType type;
        IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
        if (element instanceof IType && (type = (IType)element) != null) {
            type.exists();
        }
    }

    private boolean isAspectjType(IType type) {
        return type.getHandleIdentifier().indexOf(125) != -1;
    }

    public void contextDeactivated(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void clearTypeHistory() {
    }

    public void interestChanged(List nodes) {
        ListIterator it = nodes.listIterator();
        while (it.hasNext()) {
            IInteractionElement node = (IInteractionElement)it.next();
            this.updateTypeHistory(node, true);
        }
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateTypeHistory(node, false);
    }

    public void landmarkAdded(IInteractionElement node) {
    }

    public void landmarkRemoved(IInteractionElement node) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void contextCleared(IInteractionContext arg0) {
    }

    public void interactionObserved(InteractionEvent event) {
    }

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }
}

