/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.utils;

import java.util.regex.Pattern;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;

public class RubySyntaxUtils {
    public static final String ARRAY_GET_METHOD = "[]".intern();
    public static final String ARRAY_PUT_METHOD = "[]=".intern();
    private static final String[] operatorMethods = new String[]{"[]", "[]=", "**", "!", "~", "+", "-", "*", "/", "%", "<<", ">>", "&", "^", "|", "<=", ">", "<", ">=", "<=>", "==", "===", "!=", "=~", "+@", "-@"};
    private static final Pattern RE_METHOD_NAME = Pattern.compile("[_a-zA-Z0-9]+[\\?!=]?");

    public static ISourceRange insideMethodOperator(String contents, int pos) {
        int i = 0;
        while (i < operatorMethods.length) {
            String op = operatorMethods[i];
            int opLength = op.length();
            int j = 0;
            while (j < opLength) {
                try {
                    int start = pos - j;
                    int end = pos - j + opLength;
                    String piece = contents.substring(start, end);
                    if (piece.equals(op)) {
                        return new SourceRange(start, opLength);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static ISourceRange getEnclosingName(CharSequence contents, int pos) {
        int actualEnd;
        int actualStart;
        char c;
        if (pos < 0 || pos >= contents.length()) {
            return null;
        }
        int start = pos - 1;
        int end = pos;
        while (start >= 0 && RubySyntaxUtils.isNameChar(contents.charAt(start))) {
            --start;
        }
        if (start > 0) {
            if (contents.charAt(start) == '@') {
                if (--start > 0 && contents.charAt(start) == '@') {
                    --start;
                }
            } else if (contents.charAt(start) == '$') {
                --start;
            }
        }
        if ((end = start + 1) < contents.length() && contents.charAt(end) == '@') {
            if (++end < contents.length() && contents.charAt(end) == '@') {
                ++end;
            }
        } else if (end < contents.length() && contents.charAt(end) == '$') {
            ++end;
        }
        while (end < contents.length() && RubySyntaxUtils.isNameChar(contents.charAt(end))) {
            ++end;
        }
        if (end < contents.length() && ((c = contents.charAt(end)) == '?' || c == '!' || c == '=')) {
            ++end;
        }
        if ((actualStart = start + 1) > (actualEnd = end - 1)) {
            return null;
        }
        return new SourceRange(actualStart, actualEnd - actualStart + 1);
    }

    public static boolean isRubyName(String str) {
        int i = 0;
        while (i < operatorMethods.length) {
            if (operatorMethods[i].equals(str)) {
                return true;
            }
            ++i;
        }
        return str.matches("^(@{0,2}|\\$)[_a-zA-Z0-9]+[\\?!=]?$");
    }

    public static boolean isRubyMethodName(String str) {
        return RE_METHOD_NAME.matcher(str).matches();
    }

    public static boolean isLessStrictIdentifierCharacter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '@' || ch == '$';
    }

    public static boolean isStrictIdentifierCharacter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '@' || ch == '$';
    }

    public static boolean isIdentifierCharacter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '?' || ch == '!' || ch == '@' || ch == '$';
    }

    public static int getInclusiveStartOfIdentifierEndingAt(CharSequence document, int inclusiveEndOffset) {
        char ch = document.charAt(inclusiveEndOffset);
        if (!RubySyntaxUtils.isIdentifierCharacter(ch)) {
            return -1;
        }
        int offset = inclusiveEndOffset - 1;
        while (offset >= 0) {
            if (!RubySyntaxUtils.isIdentifierCharacter(document.charAt(offset))) {
                return offset + 1;
            }
            --offset;
        }
        return 0;
    }

    public static boolean isValidRegexpModifier(char ch) {
        switch (ch) {
            case 'e': 
            case 'i': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 's': 
            case 'u': 
            case 'x': {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPercentStringStarter(char ch) {
        switch (ch) {
            case 'Q': 
            case 'W': 
            case 'q': 
            case 'r': 
            case 's': 
            case 'w': 
            case 'x': {
                return true;
            }
        }
        return false;
    }

    public static char getPercentStringTerminator(char leader) {
        switch (leader) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '|': 
            case '}': 
            case '~': {
                return leader;
            }
        }
        return '\u0000';
    }

    public static int skipWhitespaceForward(char[] content, int offset) {
        return RubySyntaxUtils.skipWhitespaceForward(content, offset, content.length);
    }

    public static int skipWhitespaceForward(char[] content, int offset, int end) {
        int result = offset;
        while (result < end) {
            if (result < 0 || result >= content.length) break;
            if (!RubySyntaxUtils.isWhitespace(content[result])) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNonNewLineWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isRubyOperator(String op) {
        int i = 0;
        while (i < operatorMethods.length) {
            if (op.equals(operatorMethods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidConstant(String input) {
        boolean result = input.matches("[A-Z][a-zA-Z0-9_]*");
        return result;
    }

    public static boolean isValidClass(String input) {
        boolean result = false;
        if (input.indexOf("::") != -1) {
            String[] tokens = input.split("::");
            int cnt = 0;
            int max = tokens.length;
            while (cnt < max) {
                result = RubySyntaxUtils.isValidConstant(tokens[cnt]);
                if (result) {
                    ++cnt;
                    continue;
                }
                break;
            }
        } else {
            result = RubySyntaxUtils.isValidConstant(input);
        }
        return result;
    }
}

