/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.folding;

import java.util.ArrayList;
import org.eclipse.dltk.ruby.internal.ui.text.folding.RubyFoldingMessages;
import org.eclipse.dltk.ruby.internal.ui.text.folding.RubyFoldingPreferenceBlock;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.folding.IFoldingPreferenceBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RubyFoldingPreferenceBlock
extends AbstractConfigurationBlock
implements IFoldingPreferenceBlock {
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;

    public RubyFoldingPreferenceBlock(OverlayPreferenceStore store) {
        super(store);
        this.fOverlayStore = store;
        this.fKeys = this.createKeys();
        this.fOverlayStore.addKeys(this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_lines_limit"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_header_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_methods"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite composite) {
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        Composite blockFolding = this.createSubsection(inner, null, RubyFoldingMessages.RubyFoldingPreferenceBlock_10);
        blockFolding.setLayout((Layout)new GridLayout());
        IInputValidator val = new IInputValidator(){

            public String isValid(String number) {
                if (number.length() == 0) {
                    return PreferencesMessages.DLTKEditorPreferencePage_empty_input;
                }
                try {
                    int value = Integer.parseInt(number);
                    if (value < 2) {
                        return RubyFoldingMessages.RubyFoldingPreferenceBlock_youMayInputNumbers;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return RubyFoldingMessages.RubyFoldingPreferenceBlock_inputIsNotANumber;
                }
                return null;
            }
        };
        this.addLabelledTextField(blockFolding, RubyFoldingMessages.RubyFoldingPreferenceBlock_minimalAmountOfLinesToBeFolded, "editor_folding_lines_limit", 3, 1, true, val);
        Composite initialFolding = this.createSubsection(inner, null, RubyFoldingMessages.RubyFoldingPreferenceBlock_16);
        initialFolding.setLayout((Layout)new GridLayout());
        this.addCheckBox(initialFolding, RubyFoldingMessages.RubyFoldingPreference_initiallyFoldComments, "editor_folding_init_comments", 0);
        this.addCheckBox(initialFolding, RubyFoldingMessages.RubyFoldingPreference_initiallyFoldHeaderComments, "editor_folding_init_header_comments", 0);
        this.addCheckBox(initialFolding, RubyFoldingMessages.RubyFoldingPreference_initiallyFoldMethods, "editor_folding_init_methods", 0);
        return inner;
    }

    public void initialize() {
        super.initialize();
    }

    public void performDefaults() {
        super.performDefaults();
    }

    private class ListBlock {
        private ListViewer fList;
        String fKey;
        private Button fAddButton;
        private Button fRemoveButton;

        public ListBlock(Composite parent, String key) {
            this.fKey = key;
            this.createControl(parent);
        }

        private Control createControl(Composite parent) {
            Font font = parent.getFont();
            Composite comp = new Composite(parent, 0);
            GridLayout topLayout = new GridLayout();
            topLayout.numColumns = 2;
            topLayout.marginHeight = 0;
            topLayout.marginWidth = 0;
            comp.setLayout((Layout)topLayout);
            GridData gd = new GridData(1808);
            comp.setLayoutData((Object)gd);
            this.fList = new ListViewer(comp);
            gd = new GridData(1808);
            gd.heightHint = 6;
            this.fList.getControl().setLayoutData((Object)gd);
            Composite pathButtonComp = new Composite(comp, 0);
            GridLayout pathButtonLayout = new GridLayout();
            pathButtonLayout.marginHeight = 0;
            pathButtonLayout.marginWidth = 0;
            pathButtonComp.setLayout((Layout)pathButtonLayout);
            gd = new GridData(258);
            pathButtonComp.setLayoutData((Object)gd);
            pathButtonComp.setFont(font);
            this.fAddButton = this.createPushButton(pathButtonComp, RubyFoldingMessages.RubyFoldingPreferenceBlock_0);
            this.fAddButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ListBlock this$1;
                {
                    this.this$1 = listBlock;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IInputValidator validator = new IInputValidator(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public String isValid(String newText) {
                            if (newText.trim().length() > 0 && newText.matches("[_a-zA-Z]*")) {
                                return null;
                            }
                            return RubyFoldingMessages.RubyFoldingPreferenceBlock_2;
                        }
                    };
                    InputDialog dlg = new InputDialog(null, RubyFoldingMessages.RubyFoldingPreferenceBlock_3, RubyFoldingMessages.RubyFoldingPreferenceBlock_4, "", validator);
                    if (dlg.open() == 0) {
                        ListBlock.access$0(this.this$1).add((Object)dlg.getValue());
                        this.this$1.save();
                    }
                }
            });
            this.fRemoveButton = this.createPushButton(pathButtonComp, RubyFoldingMessages.RubyFoldingPreferenceBlock_6);
            this.fRemoveButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ListBlock this$1;
                {
                    this.this$1 = listBlock;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection s = ListBlock.access$0(this.this$1).getSelection();
                    if (s instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)s;
                        ListBlock.access$0(this.this$1).remove(sel.toArray());
                        this.this$1.save();
                    }
                }
            });
            return comp;
        }

        protected Button createPushButton(Composite parent, String label) {
            Button button = new Button(parent, 8);
            button.setFont(parent.getFont());
            if (label != null) {
                button.setText(label);
            }
            GridData gd = new GridData();
            button.setLayoutData((Object)gd);
            gd.widthHint = this.getButtonWidthHint(button);
            gd.horizontalAlignment = 4;
            return button;
        }

        public int getButtonWidthHint(Button button) {
            button.setFont(JFaceResources.getDialogFont());
            PixelConverter converter = new PixelConverter((Control)button);
            int widthHint = converter.convertHorizontalDLUsToPixels(61);
            return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }

        private String[] getEntries() {
            return this.fList.getList().getItems();
        }

        private void setEntries(String[] items) {
            this.fList.remove((Object[])this.fList.getList().getItems());
            int i = 0;
            while (i < items.length) {
                if (items[i].trim().length() > 0) {
                    this.fList.add((Object)items[i]);
                }
                ++i;
            }
        }

        public void save() {
            String[] items = this.getEntries();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                buf.append(items[i]);
                if (i != items.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
            RubyFoldingPreferenceBlock.this.getPreferenceStore().setValue(this.fKey, buf.toString());
        }

        public void initialize() {
            String val = RubyFoldingPreferenceBlock.this.getPreferenceStore().getString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }

        public void performDefault() {
            String val = RubyFoldingPreferenceBlock.this.getPreferenceStore().getDefaultString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }

        static /* synthetic */ ListViewer access$0(ListBlock listBlock) {
            return listBlock.fList;
        }
    }
}

