/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.tcl.core.TclParseUtil;

public class TclSourceIndexerRequestor
extends SourceIndexerRequestor {
    protected String[] realEnclosingTypeNames = new String[5];
    protected int realdepth = 0;
    Pattern pattern = Pattern.compile("::");

    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        String[] ns = this.pattern.split(methodName, 0);
        if (ns.length > 0) {
            this.indexer.addMethodReference(ns[ns.length - 1], argCount);
        }
        int i = 0;
        while (i < ns.length - 1) {
            if (ns[i].length() > 0) {
                this.indexer.addTypeReference(ns[i]);
            }
            ++i;
        }
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        if (fullName.startsWith("::")) {
            String name = fullName.substring(2);
            String[] split = TclParseUtil.tclSplit(name);
            ArrayList cEnclodingNames = new ArrayList();
            int i = 0;
            while (i < split.length) {
                this.indexer.addTypeDeclaration(2048, this.pkgName, split[i], this.eclosingTypeNamesFrom(cEnclodingNames, split, i), null);
                ++i;
            }
            this.pushTypeName(name.toCharArray());
        } else {
            List cEnclodingNames = this.enclosingTypeNamesAsList();
            String[] split = TclParseUtil.tclSplit(fullName);
            int i = 0;
            while (i < split.length) {
                this.indexer.addTypeDeclaration(2048, this.pkgName, split[i], this.eclosingTypeNamesFrom(cEnclodingNames, split, i), null);
                ++i;
            }
            this.pushTypeName(fullName.toCharArray());
        }
        return true;
    }

    private String[] eclosingTypeNamesFrom(List enclosingNames, String[] split, int i) {
        String[] result = new String[enclosingNames.size() + i];
        int index = 0;
        for (String name : enclosingNames) {
            result[index++] = name;
        }
        int j = 0;
        while (j < i) {
            result[index++] = split[j];
            ++j;
        }
        if (result.length > 0) {
            return result;
        }
        return null;
    }

    private List enclosingTypeNamesAsList() {
        ArrayList<String> cEnclosingNames = new ArrayList<String>();
        String[] enclosingTypeNames2 = this.enclosingTypeNames();
        if (enclosingTypeNames2 == null) {
            return cEnclosingNames;
        }
        int i = 0;
        while (i < enclosingTypeNames2.length) {
            cEnclosingNames.add(enclosingTypeNames2[i]);
            ++i;
        }
        return cEnclosingNames;
    }

    public boolean enterTypeAppend(IElementRequestor.TypeInfo info, String fullName, String delimiter) {
        return false;
    }

    public void enterMethodRemoveSame(IElementRequestor.MethodInfo info) {
        this.enterMethod(info);
    }

    public void popTypeName() {
        if (this.depth > 0) {
            String name = this.realEnclosingTypeNames[this.realdepth - 1];
            this.realEnclosingTypeNames[--this.realdepth] = null;
            String[] split = TclParseUtil.tclSplit(name);
            int i = 0;
            while (i < split.length) {
                super.popTypeName();
                ++i;
            }
        }
    }

    public void pushTypeName(char[] typeName) {
        String type = new String(typeName);
        String[] split = TclParseUtil.tclSplit(type);
        int i = 0;
        while (i < split.length) {
            super.pushTypeName(split[i]);
            ++i;
        }
        if (this.realdepth == this.realEnclosingTypeNames.length) {
            this.realEnclosingTypeNames = new String[this.depth * 2];
            System.arraycopy(this.realEnclosingTypeNames, 0, this.realEnclosingTypeNames, 0, this.realdepth);
        }
        this.realEnclosingTypeNames[this.realdepth++] = type;
    }

    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        if ((typeInfo.modifiers & 0x10000) == 0 && (typeInfo.modifiers & 0x8000) == 0) {
            super.enterType(typeInfo);
        } else {
            this.pushTypeName(typeInfo.name.toCharArray());
        }
    }
}

