/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.console.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.environment.EnvironmentChangedListener;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentChangedListener;
import org.eclipse.dltk.internal.launching.InterpreterListener;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.console.ui.AbstractPulldownAction;
import org.eclipse.dltk.tcl.internal.console.ui.TclConsoleFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenConsoleAction
extends AbstractPulldownAction {
    private final EnvironmentChangedListener environmentListener = new EnvironmentChangedListener(){

        public void environmentsModified() {
            OpenConsoleAction.this.fRecreateMenu = true;
        }
    };
    private final IInterpreterInstallChangedListener interpreterListener = new InterpreterListener(){

        protected void changed() {
            OpenConsoleAction.this.fRecreateMenu = true;
        }
    };

    public void init(IWorkbenchWindow window) {
        super.init(window);
        EnvironmentManager.addEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentListener);
        ScriptRuntime.addInterpreterInstallChangedListener((IInterpreterInstallChangedListener)this.interpreterListener);
    }

    public void dispose() {
        ScriptRuntime.removeInterpreterInstallChangedListener((IInterpreterInstallChangedListener)this.interpreterListener);
        EnvironmentManager.removeEnvironmentChangedListener((IEnvironmentChangedListener)this.environmentListener);
        super.dispose();
    }

    protected void fillMenu(Menu menu) {
        HashMap<String, EnvironmentEntry> environments = new HashMap<String, EnvironmentEntry>();
        IEnvironment[] iEnvironmentArray = EnvironmentManager.getEnvironments();
        int n = iEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironment environment = iEnvironmentArray[n2];
            environments.put(environment.getId(), new EnvironmentEntry(environment));
            ++n2;
        }
        iEnvironmentArray = ScriptRuntime.getInterpreterInstallTypes((String)"org.eclipse.dltk.tcl.core.nature");
        n = iEnvironmentArray.length;
        n2 = 0;
        while (n2 < n) {
            IInterpreterInstall[] installs;
            IEnvironment type = iEnvironmentArray[n2];
            IInterpreterInstall[] iInterpreterInstallArray = installs = type.getInterpreterInstalls();
            int n3 = installs.length;
            int n4 = 0;
            while (n4 < n3) {
                IInterpreterInstall install = iInterpreterInstallArray[n4];
                EnvironmentEntry entry = (EnvironmentEntry)environments.get(install.getEnvironmentId());
                if (entry != null) {
                    entry.installs.add(install);
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList list = new ArrayList(environments.values());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            EnvironmentEntry entry = (EnvironmentEntry)i.next();
            if (!entry.installs.isEmpty()) continue;
            i.remove();
        }
        Collections.sort(list, new Comparator<EnvironmentEntry>(){

            @Override
            public int compare(EnvironmentEntry o1, EnvironmentEntry o2) {
                if (o1.environment.isLocal() != o2.environment.isLocal()) {
                    return o1.environment.isLocal() ? -1 : 1;
                }
                return o1.environment.getName().compareToIgnoreCase(o2.environment.getName());
            }
        });
        for (EnvironmentEntry entry : list) {
            Menu eMenu = this.addSubmenu(menu, entry.environment.getName());
            Collections.sort(entry.installs, new Comparator<IInterpreterInstall>(){

                @Override
                public int compare(IInterpreterInstall o1, IInterpreterInstall o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (IInterpreterInstall install : entry.installs) {
                this.addToMenu(eMenu, (IAction)new OpenInstallConsoleAction(install));
            }
        }
    }

    public void run(IAction action) {
        new TclConsoleFactory().openConsole();
    }

    private static class EnvironmentEntry {
        final IEnvironment environment;
        final List<IInterpreterInstall> installs = new ArrayList<IInterpreterInstall>();

        public EnvironmentEntry(IEnvironment environment) {
            this.environment = environment;
        }
    }

    private final class OpenInstallConsoleAction
    extends Action {
        private final IInterpreterInstall install;

        private OpenInstallConsoleAction(IInterpreterInstall install) {
            super(NLS.bind((String)"{0} ({1})", (Object)install.getName(), (Object)install.getInstallLocation().toOSString()));
            this.install = install;
        }

        public void run() {
            new TclConsoleFactory().openConsole(this.install, NLS.bind((String)"{0} - {1}", (Object)this.install.getEnvironment().getName(), (Object)this.install.getInstallLocation().toOSString()));
        }
    }
}

