/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.core.packages.PackagesManager;
import org.eclipse.dltk.tcl.internal.ui.text.TclCorrectionAssistant;
import org.eclipse.dltk.tcl.internal.ui.text.TclRequirePackageMarkerResolution;
import org.eclipse.dltk.ui.text.MarkerResolutionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class TclCorrectionProcessor
implements IQuickAssistProcessor {
    TclCorrectionAssistant fAssistant;

    public TclCorrectionProcessor(TclCorrectionAssistant tclCorrectionAssistant) {
        this.fAssistant = tclCorrectionAssistant;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return TclCorrectionProcessor.isQuickFixableType(annotation);
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
        int i = 0;
        while (i < annotations.length) {
            String pkgName;
            MarkerAnnotation mAnnot;
            IMarker marker;
            Annotation annotation = annotations[i];
            if (annotation instanceof MarkerAnnotation && TclCorrectionProcessor.isFixable(marker = (mAnnot = (MarkerAnnotation)annotation).getMarker()) && (pkgName = marker.getAttribute("tcl.problem.require", null)) != null) {
                ScriptEditor editor = (ScriptEditor)this.fAssistant.getEditor();
                IModelElement element = editor.getInputModelElement();
                IScriptProject scriptProject = element.getScriptProject();
                MarkerResolutionProposal prop = new MarkerResolutionProposal((IMarkerResolution)new TclRequirePackageMarkerResolution(pkgName, scriptProject), marker);
                return new ICompletionProposal[]{prop};
            }
            ++i;
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation mAnnot = (MarkerAnnotation)annotation;
            IMarker marker = mAnnot.getMarker();
            return TclCorrectionProcessor.isFixable(marker);
        }
        return false;
    }

    public static boolean isFixable(IMarker marker) {
        String pkgName = marker.getAttribute("tcl.problem.require", null);
        if (pkgName != null) {
            IResource resource = marker.getResource();
            IProject project = resource.getProject();
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            return TclCorrectionProcessor.isFixable(pkgName, scriptProject);
        }
        return false;
    }

    public static boolean isFixable(String pkgName, IScriptProject scriptProject) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
        if (toolkit != null && toolkit.getNatureId().equals("org.eclipse.dltk.tcl.core.nature")) {
            IInterpreterInstall install;
            block6: {
                install = null;
                try {
                    install = ScriptRuntime.getInterpreterInstall((IScriptProject)scriptProject);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            if (install != null) {
                PackagesManager manager = PackagesManager.getInstance();
                IPath[] paths = manager.getPathsForPackage(install, pkgName);
                if (paths != null && paths.length > 0) {
                    return true;
                }
                Map dependencies = manager.getDependencies(pkgName, install);
                Iterator iterator = dependencies.keySet().iterator();
                while (iterator.hasNext()) {
                    String pkg = (String)iterator.next();
                    IPath[] paths2 = manager.getPathsForPackage(install, pkg);
                    if (paths2 == null || paths2.length <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasCorrections(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation mAnnot = (MarkerAnnotation)annotation;
            IMarker marker = mAnnot.getMarker();
            return TclCorrectionProcessor.isFixable(marker);
        }
        return false;
    }
}

