/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorInputTransfer;

public class EditorInputTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private ArrayList fEditorInputDatas;

    public EditorInputTransferDragAdapter(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    public Transfer getTransfer() {
        return EditorInputTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        this.fEditorInputDatas = new ArrayList();
        ISelection selection = this.fProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                IEditorInput editorInput;
                Object element;
                block4: {
                    element = iter.next();
                    editorInput = null;
                    try {
                        editorInput = EditorUtility.getEditorInput(element);
                    }
                    catch (ModelException e1) {
                        if (!DLTKCore.DEBUG) break block4;
                        e1.printStackTrace();
                    }
                }
                if (editorInput == null || editorInput.getPersistable() == null) continue;
                String editorId = EditorUtility.getEditorID(editorInput, element);
                IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor editorDesc = editorReg.findEditor(editorId);
                if (editorDesc == null || editorDesc.isOpenExternal()) continue;
                this.fEditorInputDatas.add(EditorInputTransfer.createEditorInputData((String)editorId, (IEditorInput)editorInput));
            }
        }
        event.doit = this.fEditorInputDatas.size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        if (EditorInputTransfer.getInstance().isSupportedType(event.dataType) && this.fEditorInputDatas.size() > 0) {
            event.data = this.fEditorInputDatas.toArray(new EditorInputTransfer.EditorInputData[this.fEditorInputDatas.size()]);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.fEditorInputDatas = null;
        Assert.isTrue((event.detail != 2 ? 1 : 0) != 0);
    }
}

