/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.ui.preferences.IFieldValidator;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlBindingManager {
    private Map textControls;
    private Map comboControls;
    private Map buttonControls = new HashMap();
    private IPreferenceDelegate preferenceDelegate;
    private IStatusChangeListener changeListener;
    private DependencyManager dependencyManager;
    private ValidatorManager validatorManager;

    public ControlBindingManager(IPreferenceDelegate delegate, IStatusChangeListener listener) {
        this.comboControls = new HashMap();
        this.textControls = new HashMap();
        this.validatorManager = new ValidatorManager();
        this.dependencyManager = new DependencyManager();
        this.changeListener = listener;
        this.preferenceDelegate = delegate;
    }

    public void initialize() {
        Object key;
        Iterator it = this.textControls.keySet().iterator();
        while (it.hasNext()) {
            Text text = (Text)it.next();
            key = this.textControls.get(text);
            text.setText(this.preferenceDelegate.getString(key));
        }
        it = this.buttonControls.keySet().iterator();
        while (it.hasNext()) {
            Button button = (Button)it.next();
            key = this.buttonControls.get(button);
            button.setSelection(this.preferenceDelegate.getBoolean(key));
        }
        it = this.comboControls.keySet().iterator();
        while (it.hasNext()) {
            Combo combo = (Combo)it.next();
            key = this.comboControls.get(combo);
            String value = this.preferenceDelegate.getString(key);
            String[] items = combo.getItems();
            boolean selected = false;
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(value)) {
                    combo.select(i);
                    selected = true;
                    break;
                }
                ++i;
            }
            if (selected) continue;
            combo.select(0);
        }
        this.dependencyManager.initialize();
    }

    public void bindControl(final Button button, final Object key, Control[] slaves) {
        if (key != null) {
            this.buttonControls.put(button, key);
        }
        if (slaves != null) {
            this.dependencyManager.createDependency(button, slaves);
        }
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ControlBindingManager.this.preferenceDelegate.setBoolean(key, state);
                ControlBindingManager.this.updateStatus(new StatusInfo());
            }
        });
    }

    public void bindControl(final Text text, final Object key, IFieldValidator validator) {
        if (key != null) {
            this.textControls.put(text, key);
        }
        if (validator != null) {
            this.validatorManager.registerValidator(text, validator);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = text.getText();
                IStatus status = ControlBindingManager.this.validateText(text);
                if (key != null && status.getSeverity() != 4) {
                    ControlBindingManager.this.preferenceDelegate.setString(key, value);
                }
                ControlBindingManager.this.updateStatus(status);
            }
        });
    }

    public void bindControl(final Combo combo, final String key) {
        if (key != null) {
            this.comboControls.put(combo, key);
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                ControlBindingManager.this.preferenceDelegate.setString(key, combo.getItem(index));
                ControlBindingManager.this.changeListener.statusChanged(new StatusInfo());
            }
        });
    }

    private IStatus validateText(Text text) {
        StatusInfo status = new StatusInfo();
        IFieldValidator validator = this.validatorManager.getValidator((Control)text);
        if (validator != null && text.isEnabled()) {
            status = validator.validate(text.getText());
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Iterator iter = this.textControls.keySet().iterator();
            while (iter.hasNext()) {
                IStatus s = this.validateText((Text)iter.next());
                status = StatusUtil.getMoreSevere(s, status);
            }
        }
        this.changeListener.statusChanged(status);
    }

    class DependencyManager {
        private List masterSlaveListeners = new ArrayList();

        DependencyManager() {
        }

        public void initialize() {
            Iterator it = this.masterSlaveListeners.iterator();
            while (it.hasNext()) {
                ((SelectionListener)it.next()).widgetSelected(null);
            }
        }

        public void createDependency(Button master, Control[] slaves) {
            SelectionListener listener = new SelectionListener(this, master, slaves){
                final /* synthetic */ DependencyManager this$1;
                private final /* synthetic */ Button val$master;
                private final /* synthetic */ Control[] val$slaves;
                {
                    this.this$1 = dependencyManager;
                    this.val$master = button;
                    this.val$slaves = controlArray;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean state = this.val$master.getSelection();
                    int i = 0;
                    while (i < this.val$slaves.length) {
                        this.val$slaves[i].setEnabled(state);
                        ++i;
                    }
                    ControlBindingManager.access$0(DependencyManager.access$0(this.this$1)).statusChanged(new StatusInfo());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            master.addSelectionListener(listener);
            this.masterSlaveListeners.add(listener);
        }

        static /* synthetic */ ControlBindingManager access$0(DependencyManager dependencyManager) {
            return dependencyManager.ControlBindingManager.this;
        }
    }

    class ValidatorManager {
        private Map map = new HashMap();

        ValidatorManager() {
        }

        public IFieldValidator getValidator(Control control) {
            return (IFieldValidator)this.map.get(control);
        }

        public void registerValidator(Text text, IFieldValidator validator) {
            this.map.put(text, validator);
        }

        public void unregisterValidator(Text text) {
            this.map.remove(text);
        }
    }
}

