/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.Messages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

final class ScriptCorePreferenceBlock
extends ImprovedAbstractConfigurationBlock {
    private Button nonLocalEmptyFileContentTypeChecking;

    ScriptCorePreferenceBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
    }

    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 4);
        Group g = new Group(composite, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(4, -1, true, false);
        layoutData.horizontalSpan = 2;
        g.setLayoutData((Object)layoutData);
        g.setText("Core options");
        this.nonLocalEmptyFileContentTypeChecking = new Button((Composite)g, 32);
        this.nonLocalEmptyFileContentTypeChecking.setText("Empty file content checking for non local projects");
        this.createReIndex(composite);
        return composite;
    }

    private void createReIndex(Composite composite) {
        if (DLTKCore.SHOW_REINDEX) {
            Group g = new Group(composite, 0);
            g.setLayout((Layout)new GridLayout(2, false));
            GridData layoutData = new GridData(4, -1, true, false);
            layoutData.horizontalSpan = 2;
            g.setLayoutData((Object)layoutData);
            g.setText("Debug options/operations");
            Label l = new Label((Composite)g, 8);
            l.setText(Messages.ScriptCorePreferencePage_manualReindex);
            Button reCreateIndex = new Button((Composite)g, 8);
            reCreateIndex.setText(Messages.ScriptCorePreferencePage_reindex);
            reCreateIndex.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    block4: {
                        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
                        indexManager.rebuild();
                        try {
                            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)new ReindexOperation());
                        }
                        catch (InvocationTargetException e3) {
                            if (DLTKCore.DEBUG) {
                                e3.printStackTrace();
                            }
                        }
                        catch (InterruptedException e3) {
                            if (!DLTKCore.DEBUG) break block4;
                            e3.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    protected List createOverlayKeys() {
        return null;
    }

    public void initialize() {
        super.initialize();
        Preferences preferences = DLTKCore.getPlugin().getPluginPreferences();
        String value = preferences.getString("org.eclipse.dltk.core.nonLocalEmptyFileContentCheking");
        this.nonLocalEmptyFileContentTypeChecking.setSelection("enabled".equals(value));
    }

    public void performDefaults() {
        super.performDefaults();
        Preferences preferences = DLTKCore.getPlugin().getPluginPreferences();
        String value = preferences.getDefaultString("org.eclipse.dltk.core.nonLocalEmptyFileContentCheking");
        this.nonLocalEmptyFileContentTypeChecking.setSelection("enabled".equals(value));
    }

    protected void initializeFields() {
        super.initializeFields();
    }

    public void performOk() {
        super.performOk();
        Preferences preferences = DLTKCore.getPlugin().getPluginPreferences();
        preferences.setValue("org.eclipse.dltk.core.nonLocalEmptyFileContentCheking", this.nonLocalEmptyFileContentTypeChecking.getSelection() ? "enabled" : "disabled");
        DLTKCore.getDefault().savePluginPreferences();
    }

    private final class ReindexOperation
    implements IRunnableWithProgress {
        private ReindexOperation() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block2: {
                try {
                    ResourcesPlugin.getWorkspace().build(6, monitor);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }
    }
}

