/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

public class ObjectComparison {
    public static final String IMMEDIATE_RESULT_KEY = "ImmediateResult";
    public static final String KEYSET_1 = "keySet";
    public static final String VALUESET_1 = "valueSet";
    public static final String MAP_KEY_SAME = "keySameInfo";
    public static final String MAP_VAL_SAME = "valSameInfo";
    public static final String ELEMENT_SIZE = "Element Size";
    public static final String OBJECT_TYPE = "Type";
    public static final String OBJECT_VALUES = "Values";

    public String objectValueExtraction(IJavaValue value) throws DebugException {
        String refType1 = value.getReferenceTypeName();
        List<String> interfaceCheck = ObjectComparison.getInterfaces(refType1);
        if (interfaceCheck.contains("java.lang.CharSequence")) {
            return this.stringValueExtraction((IJavaObject)value);
        }
        IVariable[] iVariableArray = value.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable v = iVariableArray[n2];
            if (v.getName().equalsIgnoreCase("value")) {
                return v.getValue().getValueString();
            }
            ++n2;
        }
        if (interfaceCheck.contains("Number")) {
            IJavaThread thread = (IJavaThread)value.getDebugTarget().getThreads()[0];
            IJavaValue stringVal = ((IJavaObject)value).sendMessage("doubleValue", "()D", null, thread, false);
            return stringVal.getValueString();
        }
        return value.toString();
    }

    private String stringValueExtraction(IJavaObject value) throws DebugException {
        IJavaThread thread = (IJavaThread)value.getDebugTarget().getThreads()[0];
        IJavaValue stringVal = value.sendMessage("toString", "()Ljava/lang/String;", null, thread, false);
        return stringVal.getValueString();
    }

    public Map<IJavaVariable, Object> setExtraction(List<IStructuredSelection> selections) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject = (IJavaObject)iValue;
            List<String> contents = this.setElementsExtraction(javaObject);
            result.put(selectedObject, contents);
        }
        return result;
    }

    public List<String> setElementsExtraction(IJavaObject javaObject1) throws DebugException {
        ArrayList<String> contents = new ArrayList<String>();
        IJavaThread thread = (IJavaThread)javaObject1.getDebugTarget().getThreads()[0];
        IJavaValue toArray = javaObject1.sendMessage("toArray", "()[Ljava/lang/Object;", null, thread, false);
        IVariable[] iVariableArray = toArray.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable ob = iVariableArray[n2];
            contents.add(this.objectValueExtraction((IJavaValue)ob.getValue()));
            ++n2;
        }
        return contents;
    }

    public Map<IJavaVariable, Object> compareCustomObjects(Map<IJavaVariable, Object> compareResults) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            HashMap<String, Cloneable> properties = new HashMap<String, Cloneable>();
            Object object = entry1.getValue();
            if (object instanceof String) {
                String obj1Value = (String)object;
                IJavaVariable key1 = entry1.getKey();
                HashSet<String> same = new HashSet<String>();
                HashSet<String> diff = new HashSet<String>();
                for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                    IJavaVariable iJavaVariable = entrySub.getKey();
                    if (key1.equals(iJavaVariable)) continue;
                    String obj1Value2 = entrySub.getValue().toString();
                    if (obj1Value.equals(obj1Value2)) {
                        same.add(iJavaVariable.getName());
                        continue;
                    }
                    diff.add(iJavaVariable.getName());
                }
                properties.put("REF_SAME", same);
                properties.put("REF_DIFF", diff);
                result.put(key1, properties);
                continue;
            }
            Map objectFields1 = (Map)entry1.getValue();
            IJavaVariable key1 = entry1.getKey();
            properties = new HashMap();
            HashMap fieldSame = new HashMap();
            HashMap filedDiff = new HashMap();
            HashMap<String, String> fieldsStatus = new HashMap<String, String>();
            for (String string : objectFields1.keySet()) {
                fieldsStatus.put(string, null);
                fieldSame.put(string, new HashSet());
                filedDiff.put(string, new HashSet());
            }
            for (Map.Entry entry : compareResults.entrySet()) {
                IJavaVariable key2 = (IJavaVariable)entry.getKey();
                if (key1.equals(key2)) continue;
                Map objectFields2 = (Map)entry.getValue();
                for (String keys : objectFields1.keySet()) {
                    String val2;
                    String val1 = (String)objectFields1.get(keys);
                    if (val1.equals(val2 = (String)objectFields2.get(keys))) {
                        ((Set)fieldSame.get(keys)).add(key2.getName());
                        continue;
                    }
                    ((Set)filedDiff.get(keys)).add(key2.getName());
                }
            }
            for (String string : fieldsStatus.keySet()) {
                Set same = (Set)fieldSame.get(string);
                Set diff = (Set)filedDiff.get(string);
                if (same.isEmpty() && !diff.isEmpty()) {
                    fieldsStatus.put(string, NLS.bind((String)DebugUIMessages.ObjectsReferenceDifferent, (Object)diff.toString()));
                    continue;
                }
                if (diff.isEmpty() && !same.isEmpty()) {
                    fieldsStatus.put(string, NLS.bind((String)DebugUIMessages.ObjectsExtractedSame, (Object)same.toString()));
                    continue;
                }
                fieldsStatus.put(string, NLS.bind((String)DebugUIMessages.ObjectsReferenceSameAndDifferent, (Object[])new Object[]{same.toString(), diff.toString()}));
            }
            properties.put("fields", fieldsStatus);
            result.put(key1, properties);
        }
        return result;
    }

    public Map<IJavaVariable, Object> compareObjects(Map<IJavaVariable, Object> compareResults) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            String val1 = entry1.getValue().toString();
            IJavaVariable key1 = entry1.getKey();
            String refType1 = key1.getValue().getReferenceTypeName();
            HashMap<String, String> properties = new HashMap<String, String>();
            ArrayList<String> sameList = new ArrayList<String>();
            ArrayList<String> diffList = new ArrayList<String>();
            for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                IJavaVariable key2 = entrySub.getKey();
                if (key1.equals(key2)) continue;
                String val2 = entrySub.getValue().toString();
                if (val1.equals(val2)) {
                    sameList.add(key2.getName());
                    continue;
                }
                diffList.add(key2.getName());
            }
            if (diffList.isEmpty()) {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.ObjectsSameValue, (Object[])new Object[]{((Object)sameList).toString()}));
            } else if (!diffList.isEmpty() && !sameList.isEmpty()) {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.ObjectsSameValueAndDifferentValue, (Object[])new Object[]{((Object)sameList).toString(), ((Object)diffList).toString()}));
            } else {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.DifferentValue, (Object[])new Object[]{((Object)diffList).toString()}));
            }
            properties.put(OBJECT_TYPE, refType1);
            result.put(key1, properties);
        }
        return result;
    }

    public Map<IJavaVariable, Object> extractCustomObjects(List<IStructuredSelection> selections) throws Exception {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject1 = (IJavaObject)iValue;
            if (javaObject1.getVariables().length == 0) {
                result.put(selectedObject, javaObject1.getValueString());
                continue;
            }
            Map<String, String> fields = this.customObjectValueExtraction(javaObject1);
            result.put(selectedObject, fields);
        }
        return result;
    }

    public Map<IJavaVariable, Object> customObjectsReferencesExtraction(List<IStructuredSelection> selections) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject = (IJavaObject)iValue;
            result.put(selectedObject, javaObject);
        }
        return result;
    }

    public boolean objectsRefCheck(Map<IJavaVariable, Object> compareResults) {
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            String val1 = entry1.getValue().toString();
            IJavaVariable key1 = entry1.getKey();
            for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                String val2;
                IJavaVariable key2 = entrySub.getKey();
                if (key1.equals(key2) || val1.equals(val2 = entrySub.getValue().toString())) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, String> customObjectValueExtraction(IJavaObject javaObject1) throws DebugException {
        HashMap<String, String> contents = new HashMap<String, String>();
        IVariable[] iVariableArray = javaObject1.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            String content;
            IVariable ob = iVariableArray[n2];
            IValue iValue = ob.getValue();
            if (iValue instanceof IJavaObject) {
                IJavaObject javaObj = (IJavaObject)iValue;
                content = this.objectValueExtraction((IJavaValue)javaObj);
            } else {
                content = ob.getValue().getValueString();
            }
            contents.put(ob.getName(), content);
            ++n2;
        }
        return contents;
    }

    public Map<IJavaVariable, Object> extractOtherObjects(List<IStructuredSelection> selections) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject1 = (IJavaObject)iValue;
            String contents = this.objectValueExtraction((IJavaValue)javaObject1);
            result.put(selectedObject, contents);
        }
        return result;
    }

    public Map<IJavaVariable, Object> arrayExtraction(List<IStructuredSelection> selections) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            if (!(selection instanceof IJavaVariable)) continue;
            IJavaVariable selectedObject = (IJavaVariable)selection;
            List<String> contents = this.arrayElementsExtraction(selectedObject);
            result.put(selectedObject, contents);
        }
        return result;
    }

    public List<String> arrayElementsExtraction(IJavaVariable selectedObject1) throws DebugException {
        ArrayList<String> arrayElements1 = new ArrayList<String>();
        IValue iValue = selectedObject1.getValue();
        if (iValue instanceof IJavaValue) {
            IJavaValue javaVal1 = (IJavaValue)iValue;
            IVariable[] iVariableArray = javaVal1.getVariables();
            int n = iVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable jv = iVariableArray[n2];
                String val1 = this.objectValueExtraction((IJavaValue)jv.getValue());
                arrayElements1.add(val1);
                ++n2;
            }
        }
        return arrayElements1;
    }

    public <T> boolean listContentsCheck(List<T> l1, List<T> l2) {
        for (T t : l1) {
            if (l2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public Map<IJavaVariable, Object> stringCompare(Map<IJavaVariable, Object> compareResults) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            String val1 = (String)entry1.getValue();
            IJavaVariable key1 = entry1.getKey();
            String refType1 = key1.getValue().getReferenceTypeName();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ArrayList<String> sameList = new ArrayList<String>();
            ArrayList<String> diffList = new ArrayList<String>();
            for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                IJavaVariable key2 = entrySub.getKey();
                if (key1.equals(key2)) continue;
                String val2 = (String)entrySub.getValue();
                if (val1.equals(val2)) {
                    sameList.add(key2.getName());
                    continue;
                }
                diffList.add(key2.getName());
            }
            if (diffList.isEmpty()) {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.StringSame, (Object[])new Object[]{((Object)sameList).toString()}));
            } else if (!diffList.isEmpty() && !sameList.isEmpty()) {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.StringSameAndDifferent, (Object[])new Object[]{((Object)sameList).toString(), ((Object)diffList).toString()}));
            } else {
                properties.put(IMMEDIATE_RESULT_KEY, NLS.bind((String)DebugUIMessages.StringDifferent, (Object[])new Object[]{((Object)diffList).toString()}));
            }
            properties.put(ELEMENT_SIZE, val1.length());
            properties.put(OBJECT_TYPE, refType1);
            result.put(key1, properties);
        }
        return result;
    }

    public Map<IJavaVariable, Object> compareSelectedLists(Map<IJavaVariable, Object> compareResults, String interfaceType) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            List listV1 = (List)entry1.getValue();
            int size = listV1.size();
            IJavaVariable key1 = entry1.getKey();
            HashMap<String, String> missingData = new HashMap<String, String>();
            String refType1 = key1.getValue().getReferenceTypeName();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ArrayList differencesMain = new ArrayList();
            for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                String message;
                IJavaVariable key2 = entrySub.getKey();
                if (key1.equals(key2)) continue;
                ArrayList<String> differencesCurrent = new ArrayList<String>();
                List listV2 = (List)entrySub.getValue();
                if (listV1.equals(listV2)) {
                    message = NLS.bind((String)DebugUIMessages.ListSameElements, (Object[])new Object[]{interfaceType, key2.getName()});
                    properties.put(IMMEDIATE_RESULT_KEY, message);
                    continue;
                }
                if (this.listContentsCheck(listV1, listV2) && this.listContentsCheck(listV2, listV1)) {
                    if (key1.getSignature().contains("Set") || key2.getSignature().contains("Set")) {
                        message = NLS.bind((String)DebugUIMessages.ListSameElements, (Object[])new Object[]{interfaceType, key2.getName()});
                        properties.put(IMMEDIATE_RESULT_KEY, message);
                        continue;
                    }
                    message = NLS.bind((String)DebugUIMessages.ListSameELementsInDiffOrder, (Object[])new Object[]{interfaceType, key2.getName()});
                    properties.put(IMMEDIATE_RESULT_KEY, message);
                    continue;
                }
                for (String item : listV2) {
                    if (listV1.contains(item) || differencesCurrent.contains(item)) continue;
                    differencesCurrent.add(item);
                }
                if (differencesCurrent.isEmpty()) continue;
                missingData.put(key2.getName(), ((Object)differencesCurrent).toString());
                differencesMain = new ArrayList(differencesCurrent);
            }
            if (!differencesMain.isEmpty()) {
                String listString = ((Object)missingData).toString();
                properties.put("MultiValues", listString);
                properties.put(OBJECT_VALUES, differencesMain);
            }
            properties.put(ELEMENT_SIZE, size);
            properties.put(OBJECT_TYPE, refType1);
            result.put(key1, properties);
        }
        return result;
    }

    public Map<IJavaVariable, Object> compareSelectedMaps(Map<IJavaVariable, Object> compareResults) throws DebugException {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (Map.Entry<IJavaVariable, Object> entry1 : compareResults.entrySet()) {
            Map current = (Map)entry1.getValue();
            List listV1 = (List)current.get(VALUESET_1);
            IJavaVariable key1 = entry1.getKey();
            List keyList1 = (List)current.get(KEYSET_1);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            HashMap<String, String> missingKeyData = new HashMap<String, String>();
            HashMap<String, String> missingValData = new HashMap<String, String>();
            HashSet<String> keySimilarities = new HashSet<String>();
            HashSet<String> valueSimilarities = new HashSet<String>();
            HashSet<String> keyDifferences = new HashSet<String>();
            HashSet<String> valueDifferences = new HashSet<String>();
            for (Map.Entry<IJavaVariable, Object> entrySub : compareResults.entrySet()) {
                Map currentSub = (Map)entrySub.getValue();
                IJavaVariable key2 = entrySub.getKey();
                if (key1.equals(key2)) continue;
                keySimilarities.clear();
                valueSimilarities.clear();
                keyDifferences.clear();
                valueDifferences.clear();
                List listV2 = (List)currentSub.get(VALUESET_1);
                List keyList2 = (List)currentSub.get(KEYSET_1);
                if (keyList1.equals(keyList2) || this.listContentsCheck(keyList1, keyList2) && this.listContentsCheck(keyList2, keyList1) && keyList2.size() == keyList1.size()) {
                    keySimilarities.add(key2.getName());
                } else {
                    for (String item : keyList2) {
                        if (keyList1.contains(item)) continue;
                        keyDifferences.add(item);
                    }
                    if (!keyDifferences.isEmpty()) {
                        missingKeyData.put(key2.getName(), ((Object)keyDifferences).toString());
                    }
                }
                if (listV1.equals(listV2) || this.listContentsCheck(listV2, listV1) && this.listContentsCheck(listV1, listV2) && listV1.size() == listV2.size()) {
                    valueSimilarities.add(key2.getName());
                    continue;
                }
                for (String item : listV2) {
                    if (listV1.contains(item)) continue;
                    valueDifferences.add(item);
                }
                if (valueDifferences.isEmpty()) continue;
                missingValData.put(key2.getName(), ((Object)valueDifferences).toString());
            }
            if (keyDifferences.isEmpty() || valueDifferences.isEmpty()) {
                if (!keySimilarities.isEmpty()) {
                    properties.put(MAP_KEY_SAME, NLS.bind((String)DebugUIMessages.MapKeysSame, (Object[])new Object[]{((Object)keySimilarities).toString()}));
                }
                if (!valueSimilarities.isEmpty()) {
                    properties.put(MAP_VAL_SAME, NLS.bind((String)DebugUIMessages.MapValuesSame, (Object[])new Object[]{((Object)valueSimilarities).toString()}));
                }
            }
            if (!missingKeyData.isEmpty()) {
                properties.put("MapKeys", new ArrayList(keyDifferences));
                String listKeyString = ((Object)missingKeyData).toString();
                properties.put("MultiMapKeys", listKeyString);
            }
            if (!missingValData.isEmpty()) {
                properties.put("MapValues", new ArrayList(valueDifferences));
                String listValString = ((Object)missingValData).toString();
                properties.put("MultiMapValues", listValString);
            }
            properties.put(ELEMENT_SIZE, keyList1.size());
            properties.put(OBJECT_TYPE, key1.getValue().getReferenceTypeName());
            result.put(key1, properties);
        }
        return result;
    }

    public Map<IJavaVariable, Object> iterableExtraction(List<IStructuredSelection> selections) throws Exception {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject1 = (IJavaObject)iValue;
            List<String> contents = this.iterableElementsExtraction(javaObject1);
            result.put(selectedObject, contents);
        }
        return result;
    }

    public List<String> iterableElementsExtraction(IJavaObject javaObject1) throws DebugException {
        IJavaValue hasNext;
        ArrayList<String> contents = new ArrayList<String>();
        IJavaThread thread = (IJavaThread)javaObject1.getDebugTarget().getThreads()[0];
        IJavaObject iterator = (IJavaObject)javaObject1.sendMessage("iterator", "()Ljava/util/Iterator;", null, thread, false);
        while (!(hasNext = iterator.sendMessage("hasNext", "()Z", null, thread, false)).getValueString().equals("false")) {
            IJavaValue next = iterator.sendMessage("next", "()Ljava/lang/Object;", null, thread, false);
            String value = this.objectValueExtraction(next);
            contents.add(value);
        }
        return contents;
    }

    public Map<IJavaVariable, Object> listExtraction(List<IStructuredSelection> selections) throws Exception {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject1 = (IJavaObject)iValue;
            List<String> contents = this.listElementsExtraction(javaObject1);
            result.put(selectedObject, contents);
        }
        return result;
    }

    public List<String> listElementsExtraction(IJavaObject javaObject1) throws DebugException {
        ArrayList<String> contents = new ArrayList<String>();
        IJavaThread thread = (IJavaThread)javaObject1.getDebugTarget().getThreads()[0];
        IJavaValue toArray = javaObject1.sendMessage("toArray", "()[Ljava/lang/Object;", null, thread, false);
        IVariable[] iVariableArray = toArray.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable ob = iVariableArray[n2];
            contents.add(this.objectValueExtraction((IJavaValue)ob.getValue()));
            ++n2;
        }
        return contents;
    }

    public Map<IJavaVariable, Object> mapExtraction(List<IStructuredSelection> selections) throws Exception {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            if (!(selection instanceof IJavaVariable)) continue;
            IJavaVariable selectedObject = (IJavaVariable)selection;
            Map<String, Object> mapData = this.mapElementsExtraction(selectedObject);
            result.put(selectedObject, mapData);
        }
        return result;
    }

    public Map<IJavaVariable, Object> stringExtraction(List<IStructuredSelection> selections) throws Exception {
        HashMap<IJavaVariable, Object> result = new HashMap<IJavaVariable, Object>();
        for (IStructuredSelection selection : selections) {
            IJavaVariable selectedObject;
            IValue iValue;
            if (!(selection instanceof IJavaVariable) || !((iValue = (selectedObject = (IJavaVariable)selection).getValue()) instanceof IJavaObject)) continue;
            IJavaObject javaObject1 = (IJavaObject)iValue;
            String value = this.stringValueExtraction(javaObject1);
            result.put(selectedObject, value);
        }
        return result;
    }

    public Map<String, Object> mapElementsExtraction(IJavaVariable selectedObject1) throws DebugException {
        IValue iValue = selectedObject1.getValue();
        if (iValue instanceof IJavaObject) {
            IJavaObject javaObject1 = (IJavaObject)iValue;
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList<String> keySet = new ArrayList<String>();
            IJavaThread thread = (IJavaThread)javaObject1.getDebugTarget().getThreads()[0];
            IJavaObject keySetObject = (IJavaObject)javaObject1.sendMessage(KEYSET_1, "()Ljava/util/Set;", null, thread, false);
            IJavaValue keyToArray = keySetObject.sendMessage("toArray", "()[Ljava/lang/Object;", null, thread, false);
            IVariable[] iVariableArray = keyToArray.getVariables();
            int n = iVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable ob = iVariableArray[n2];
                keySet.add(this.objectValueExtraction((IJavaValue)ob.getValue()));
                ++n2;
            }
            ArrayList<String> valueSet = new ArrayList<String>();
            IJavaObject valueSetObject = (IJavaObject)javaObject1.sendMessage("values", "()Ljava/util/Collection;", null, thread, false);
            IJavaValue valToArray = valueSetObject.sendMessage("toArray", "()[Ljava/lang/Object;", null, thread, false);
            IVariable[] iVariableArray2 = valToArray.getVariables();
            int n3 = iVariableArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IVariable ob = iVariableArray2[n4];
                valueSet.add(this.objectValueExtraction((IJavaValue)ob.getValue()));
                ++n4;
            }
            result.put(KEYSET_1, keySet);
            result.put(VALUESET_1, valueSet);
            return result;
        }
        return null;
    }

    public static List<String> getInterfaces(String className) {
        ArrayList<String> names;
        if (className.contains("<")) {
            className = className.substring(0, className.indexOf(60));
        }
        try {
            List<Class<?>> interfaces = List.of(Class.forName(className).getInterfaces());
            if (interfaces.isEmpty()) {
                interfaces = List.of(Class.forName(className).getSuperclass().getInterfaces());
            }
            names = new ArrayList<String>(interfaces.stream().map(Class::getCanonicalName).toList());
            names.add(Class.forName(className).getSuperclass().getSimpleName());
        }
        catch (Exception e) {
            names = new ArrayList<String>();
            names.add(className);
        }
        return names;
    }

    public static String checkInterfaces(String className) {
        block18: {
            Class<?> cls;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        if (className.contains("<")) {
                                            className = className.substring(0, className.indexOf(60));
                                        }
                                        try {
                                            cls = Class.forName(className);
                                            if (!List.class.isAssignableFrom(cls)) break block11;
                                            return "Lists";
                                        }
                                        catch (Exception e) {
                                            return className;
                                        }
                                    }
                                    if (!Map.class.isAssignableFrom(cls)) break block12;
                                    return "Maps";
                                }
                                if (!Queue.class.isAssignableFrom(cls)) break block13;
                                return "Queues";
                            }
                            if (!Set.class.isAssignableFrom(cls)) break block14;
                            return "Sets";
                        }
                        if (!Deque.class.isAssignableFrom(cls)) break block15;
                        return "Deques";
                    }
                    if (!CharSequence.class.isAssignableFrom(cls)) break block16;
                    return "CharSequences";
                }
                if (!Number.class.isAssignableFrom(cls) && !Constable.class.isAssignableFrom(cls)) break block17;
                return "Wrappers";
            }
            if (!Iterable.class.isAssignableFrom(cls)) break block18;
            return "Iterables";
        }
        return className;
    }
}

