/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTestSupport {
    private static final boolean FEATURE_ENABLED = Boolean.parseBoolean(System.getProperty("m2e.process.test.configuration", "true"));
    private static final Logger LOG = LoggerFactory.getLogger(UnitTestSupport.class);
    private static final String SHOULD_RUN_METHOD = "shouldRun";
    private static final String GET_INCLUDED_AND_EXCLUDED_TESTS_METHOD = "getIncludedAndExcludedTests";
    private static final String LAUNCH_CONFIG_MAIN_CLASS = "org.eclipse.jdt.launching.MAIN_TYPE";
    private static final String LAUNCH_CONFIG_PROJECT = "org.eclipse.jdt.launching.PROJECT_ATTR";
    public static final String LAUNCH_CONFIG_VM_ARGUMENTS = "org.eclipse.jdt.launching.VM_ARGUMENTS";
    public static final String LAUNCH_CONFIG_ENVIRONMENT_VARIABLES = "org.eclipse.debug.core.environmentVariables";
    private static final String LAUNCH_CONFIG_WORKING_DIRECTORY = "org.eclipse.jdt.launching.WORKING_DIRECTORY";
    private static final String PLUGIN_ARGLINE = "argLine";
    private static final String PLUGIN_ENVIRONMENT_VARIABLES = "environmentVariables";
    private static final String PLUGIN_SYSPROP_VARIABLES = "systemPropertyVariables";
    private static final String PLUGIN_WORKING_DIRECTORY = "workingDirectory";
    private static final String PLUGIN_ENABLE_ASSERTIONS = "enableAssertions";
    private static final String GOAL_TEST = "test";
    private static final String GOAL_INTEGRATION_TEST = "integration-test";
    private static final String SUREFIRE_PLUGIN_ARTIFACT_ID = "maven-surefire-plugin";
    private static final String FAILSAFE_PLUGIN_ARTIFACT_ID = "maven-failsafe-plugin";
    private static final Pattern DEFERRED_VAR_PATTERN = Pattern.compile("@\\{(.*?)\\}");
    private static final String MAVEN_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final List<ExecutionId> TEST_EXECUTIONS = List.of(new ExecutionId("org.apache.maven.plugins", "maven-surefire-plugin", "test"), new ExecutionId("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test"));
    private static final Set<String> CONSIDERED_LAUNCH_TYPES = Set.of("org.eclipse.jdt.junit.launchconfig", "org.testng.eclipse.launchconfig");

    public static void resetLaunchConfigurations(IProject project) {
        if (FEATURE_ENABLED) {
            new ConfigurationManager().setupLaunchConfigurations(project);
        }
    }

    public static void setupLaunchConfigurationFromMavenConfiguration(ILaunchConfiguration configuration) {
        if (FEATURE_ENABLED) {
            new ConfigurationManager().setupLaunchConfiguration(configuration);
        }
    }

    private static boolean isSupportedType(String id) {
        return id != null && CONSIDERED_LAUNCH_TYPES.contains(id);
    }

    private static String resolveDeferredVariables(MavenProject mavenProject, String value) {
        Properties properties = mavenProject.getProperties();
        if (properties.isEmpty() || value == null) {
            return value;
        }
        return DEFERRED_VAR_PATTERN.matcher(value).replaceAll(match -> {
            String placeholder = match.group();
            String key = match.group(1);
            String replacement = properties.getProperty(key);
            return replacement != null ? replacement : placeholder;
        });
    }

    static /* synthetic */ Logger access$0() {
        return LOG;
    }

    private static class ConfigurationManager {
        private final Map<MojoExecution, Mojo> mojoCache = new HashMap<MojoExecution, Mojo>();

        private ConfigurationManager() {
        }

        public void setupLaunchConfigurations(IProject project) {
            if (project != null && project.exists()) {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                for (String launchTypeId : CONSIDERED_LAUNCH_TYPES) {
                    try {
                        ILaunchConfiguration[] configurations;
                        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(launchTypeId);
                        if (type == null) continue;
                        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations(type);
                        int n = configurations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                            String configurationProjectName = configuration.getAttribute(UnitTestSupport.LAUNCH_CONFIG_PROJECT, "");
                            if (project.getName().equals(configurationProjectName)) {
                                LOG.info("Reset launch configuration name: {}", (Object)configuration.getName());
                                this.setupLaunchConfiguration(configuration);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setupLaunchConfiguration(ILaunchConfiguration configuration) {
            try {
                if (!UnitTestSupport.isSupportedType(configuration.getType().getIdentifier())) {
                    return;
                }
                IProject project = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration).getProject();
                if (!MavenPlugin.isMavenProject((IProject)project)) return;
                switch (configuration.getType().getIdentifier()) {
                    case "org.eclipse.jdt.junit.launchconfig": 
                    case "org.testng.eclipse.launchconfig": {
                        LOG.info("Updating {} from maven configuration", (Object)configuration.getName());
                        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
                        TestLaunchArguments args = this.getTestLaunchArguments(configuration, facade, null);
                        if (args == null) return;
                        this.defineConfigurationValues(project, configuration, args);
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (CoreException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }

        private void defineConfigurationValues(IProject project, ILaunchConfiguration configuration, TestLaunchArguments args) throws CoreException {
            ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
            StringJoiner launchArguments = new StringJoiner("\n");
            if (args.enableAssertions()) {
                launchArguments.add("-ea");
            }
            if (args.argLine() != null) {
                launchArguments.add(args.argLine());
            }
            if (args.systemPropertyVariables() != null) {
                args.systemPropertyVariables().entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).forEach(e -> {
                    StringJoiner stringJoiner2 = launchArguments.add("-D" + (String)e.getKey() + "=" + (String)e.getValue());
                });
            }
            copy.setAttribute(UnitTestSupport.LAUNCH_CONFIG_VM_ARGUMENTS, launchArguments.toString());
            try {
                if (args.workingDirectory() != null && !Files.isSameFile(project.getLocation().toPath().toAbsolutePath(), args.workingDirectory().toPath())) {
                    copy.setAttribute(UnitTestSupport.LAUNCH_CONFIG_WORKING_DIRECTORY, args.workingDirectory().getAbsolutePath());
                } else {
                    copy.setAttribute(UnitTestSupport.LAUNCH_CONFIG_WORKING_DIRECTORY, null);
                }
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            if (args.environmentVariables() != null) {
                Map<String, String> filteredMap = args.environmentVariables().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                copy.setAttribute(UnitTestSupport.LAUNCH_CONFIG_ENVIRONMENT_VARIABLES, filteredMap);
            }
            copy.doSave();
        }

        private TestLaunchArguments getTestLaunchArguments(ILaunchConfiguration configuration, IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
            String testClass = configuration.getAttribute(UnitTestSupport.LAUNCH_CONFIG_MAIN_CLASS, "");
            MavenProject mavenProject = facade.getMavenProject();
            ArrayList executions = new ArrayList();
            for (ExecutionId id : TEST_EXECUTIONS) {
                executions.addAll(facade.getMojoExecutions(id.groupId(), id.artifactId(), monitor, new String[]{id.goal()}));
            }
            List<MojoExecution> handlers = executions.stream().filter(e -> this.isTestHandledByPlugin(facade, monitor, (MojoExecution)e, testClass)).toList();
            Iterator<MojoExecution> iterator = handlers.iterator();
            if (iterator.hasNext()) {
                MojoExecution execution = iterator.next();
                return this.getTestLaunchArguments(mavenProject, execution, monitor);
            }
            return null;
        }

        private boolean isTestHandledByPlugin(IMavenProjectFacade facade, IProgressMonitor monitor, MojoExecution execution, String testClass) {
            String testFile = testClass.replace(".", "/") + ".class";
            Optional<Mojo> mojo = this.getMojoInstance(facade, execution, monitor);
            Optional<Object> testResolverInstance = mojo.map(o -> ConfigurationManager.uncheckedInvoke(o, UnitTestSupport.GET_INCLUDED_AND_EXCLUDED_TESTS_METHOD, new Object[0]));
            Boolean isTestHandled = testResolverInstance.map(o -> ConfigurationManager.uncheckedInvoke(o, UnitTestSupport.SHOULD_RUN_METHOD, testFile, "")).map(Boolean.class::cast).orElse(false);
            return isTestHandled;
        }

        private static Object uncheckedInvoke(Object instance, String methodName, Object ... arguments) {
            Class<?> searchClass = instance.getClass();
            Class[] parameters = (Class[])Arrays.stream(arguments).map(p -> p.getClass()).toArray(Class[]::new);
            while (searchClass != null) {
                block5: {
                    try {
                        Method method = searchClass.getDeclaredMethod(methodName, parameters);
                        if (!method.trySetAccessible()) {
                            LOG.error("Cannot make accessible {}", (Object)method);
                            break block5;
                        }
                        return method.invoke(instance, arguments);
                    }
                    catch (NoSuchMethodException | SecurityException ex) {
                        LOG.debug(ex.getMessage(), (Throwable)ex);
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                searchClass = searchClass.getSuperclass();
            }
            return null;
        }

        public Optional<Mojo> getMojoInstance(IMavenProjectFacade facade, MojoExecution execution, IProgressMonitor monitor) {
            return Optional.ofNullable(this.mojoCache.computeIfAbsent(execution, exe -> {
                try {
                    return (Mojo)facade.createExecutionContext().execute(facade.getMavenProject(), (context, pm) -> (Mojo)MavenPlugin.getMaven().getConfiguredMojo(context.getSession(), exe, Mojo.class), monitor);
                }
                catch (CoreException ex) {
                    LOG.error("Unable to instanciate mojo instance", (Throwable)ex);
                    return null;
                }
            }));
        }

        private TestLaunchArguments getTestLaunchArguments(MavenProject mavenProject, MojoExecution execution, IProgressMonitor monitor) {
            try {
                IMaven maven = MavenPlugin.getMaven();
                String argLine = (String)maven.getMojoParameterValue(mavenProject, execution, UnitTestSupport.PLUGIN_ARGLINE, String.class, monitor);
                argLine = UnitTestSupport.resolveDeferredVariables(mavenProject, argLine);
                return new TestLaunchArguments(argLine, (Map)maven.getMojoParameterValue(mavenProject, execution, UnitTestSupport.PLUGIN_SYSPROP_VARIABLES, Map.class, monitor), (Map)maven.getMojoParameterValue(mavenProject, execution, UnitTestSupport.PLUGIN_ENVIRONMENT_VARIABLES, Map.class, monitor), (File)maven.getMojoParameterValue(mavenProject, execution, UnitTestSupport.PLUGIN_WORKING_DIRECTORY, File.class, monitor), (Boolean)maven.getMojoParameterValue(mavenProject, execution, UnitTestSupport.PLUGIN_ENABLE_ASSERTIONS, Boolean.class, monitor));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private record ExecutionId(String groupId, String artifactId, String goal) {
    }

    private record TestLaunchArguments(String argLine, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables, File workingDirectory, boolean enableAssertions) {
    }
}

