/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerType;

public class ConfigurationResourceListener
implements IResourceChangeListener {
    private IProject serversProject;
    private List<String> errorLogged = new ArrayList<String>();

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] childDelta;
        IResourceDelta serversProjectDelta;
        IResourceDelta delta;
        IProject project;
        if (event.getType() == 1 && (project = this.getServersProject()) != null && (delta = event.getDelta()) != null && (serversProjectDelta = delta.findMember(project.getFullPath())) != null && (childDelta = serversProjectDelta.getAffectedChildren()).length > 0) {
            IServer[] servers = ServerCore.getServers();
            int i = 0;
            while (i < childDelta.length) {
                int j = 0;
                while (j < servers.length) {
                    IFolder configFolder;
                    IServerType serverType = servers[j].getServerType();
                    String tomcatServerTypePrefix = "org.eclipse.jst.server.tomcat.";
                    if (serverType == null) {
                        if (!this.errorLogged.contains(servers[j].getName())) {
                            this.errorLogged.add(servers[j].getName());
                            TomcatPlugin.log("Could not determine server type for " + servers[j].getName());
                        }
                    } else if (serverType.getId() != null && serverType.getId().length() > tomcatServerTypePrefix.length() && tomcatServerTypePrefix.equals(serverType.getId().substring(0, tomcatServerTypePrefix.length())) && (configFolder = servers[j].getServerConfiguration()) != null && childDelta[i].getFullPath().equals((Object)configFolder.getFullPath())) {
                        TomcatServerBehaviour tcServerBehaviour = (TomcatServerBehaviour)servers[j].loadAdapter(TomcatServerBehaviour.class, null);
                        if (tcServerBehaviour == null) break;
                        tcServerBehaviour.setTomcatServerPublishState(2);
                        tcServerBehaviour.setTomcatServerRestartState(true);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject getServersProject() {
        if (this.serversProject == null) {
            try {
                IProject project = ServerType.getServerProject();
                ConfigurationResourceListener configurationResourceListener = this;
                synchronized (configurationResourceListener) {
                    this.serversProject = project;
                }
            }
            catch (CoreException coreException) {}
        }
        return this.serversProject;
    }
}

