/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextComputationStrategy;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.internal.context.core.StrategiesExtensionPointReader;
import org.eclipse.mylyn.internal.context.ui.CompoundContextComputationStrategy;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.progress.UIJob;

public class ContextPopulationStrategy {
    private static final String PART_ID = ContextPopulationStrategy.class.getName();
    private ContextComputationStrategy contextComputationStrategy;
    private boolean disabled;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void populateContext(final IInteractionContext context, final IAdaptable input) {
        Job job = new Job(Messages.ContextPopulationStrategy_Populate_Context_Job_Label){

            protected IStatus run(IProgressMonitor monitor) {
                ContextComputationStrategy strategy = ContextPopulationStrategy.this.getContextComputationStrategy();
                if (strategy == null) {
                    return Status.CANCEL_STATUS;
                }
                final List contextItems = strategy.computeContext(context, input, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!contextItems.isEmpty()) {
                    UIJob uiJob = new UIJob(Messages.ContextPopulationStrategy_Populate_Context_Job_Label){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IInteractionContext activeContext = ContextCore.getContextManager().getActiveContext();
                            if (activeContext != null && activeContext.getHandleIdentifier() != null && activeContext.getHandleIdentifier().equals(context.getHandleIdentifier())) {
                                monitor.beginTask(Messages.ContextPopulationStrategy_Populate_Context_Job_Label, contextItems.size());
                                try {
                                    for (Object element : contextItems) {
                                        String handleIdentifier;
                                        monitor.worked(1);
                                        AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge(element);
                                        if (structureBridge == null || (handleIdentifier = structureBridge.getHandleIdentifier(element)) == null) continue;
                                        try {
                                            ContextCore.getContextManager().processInteractionEvent(new InteractionEvent(InteractionEvent.Kind.SELECTION, structureBridge.getContentType(), handleIdentifier, PART_ID));
                                        }
                                        catch (Exception e) {
                                            Status status = new Status(4, "org.eclipse.mylyn.context.ui", "Unexpected error manipulating context", (Throwable)e);
                                            ContextUiPlugin.getDefault().getLog().log((IStatus)status);
                                        }
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                                if (!activeContext.getAllElements().isEmpty() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable")) {
                                    IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.getInstance().getWorkbenchWindows();
                                    int n = iWorkbenchWindowArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                                        int n3 = iWorkbenchPageArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                                            IViewReference[] iViewReferenceArray = page.getViewReferences();
                                            int n5 = iViewReferenceArray.length;
                                            int n6 = 0;
                                            while (n6 < n5) {
                                                AbstractFocusViewAction applyAction;
                                                IViewReference viewReference = iViewReferenceArray[n6];
                                                IViewPart viewPart = (IViewPart)viewReference.getPart(false);
                                                if (viewPart != null && (applyAction = AbstractFocusViewAction.getActionForPart(viewPart)) != null) {
                                                    applyAction.update(true);
                                                }
                                                ++n6;
                                            }
                                            ++n4;
                                        }
                                        ++n2;
                                    }
                                }
                            }
                            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public synchronized ContextComputationStrategy getContextComputationStrategy() {
        if (this.contextComputationStrategy == null) {
            List strategies = StrategiesExtensionPointReader.readContextComputationStrategies();
            if (strategies.isEmpty()) {
                this.disabled = true;
            } else if (strategies.size() > 1) {
                CompoundContextComputationStrategy compoundStrategy = new CompoundContextComputationStrategy();
                compoundStrategy.setDelegates(strategies);
                this.contextComputationStrategy = compoundStrategy;
            } else {
                this.contextComputationStrategy = (ContextComputationStrategy)strategies.get(0);
            }
        }
        return this.contextComputationStrategy;
    }

    public void setContextComputationStrategy(ContextComputationStrategy contextComputationStrategy) {
        this.contextComputationStrategy = contextComputationStrategy;
    }
}

