/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;

class ChoicePattern
extends BinaryPattern {
    ChoicePattern(Pattern pattern, Pattern pattern2) {
        super(pattern.isNullable() || pattern2.isNullable(), ChoicePattern.combineHashCode(11, pattern.hashCode(), pattern2.hashCode()), pattern, pattern2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p1.expand(schemaPatternBuilder);
        Pattern pattern2 = this.p2.expand(schemaPatternBuilder);
        if (pattern != this.p1 || pattern2 != this.p2) {
            return schemaPatternBuilder.makeChoice(pattern, pattern2);
        }
        return this;
    }

    @Override
    boolean containsChoice(Pattern pattern) {
        return this.p1.containsChoice(pattern) || this.p2.containsChoice(pattern);
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseChoice(this);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.startChoice();
        }
        this.p1.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.alternative();
        }
        this.p2.checkRestrictions(n, duplicateAttributeDetector, alphabet);
        if (duplicateAttributeDetector != null) {
            duplicateAttributeDetector.endChoice();
        }
    }
}

