/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.archive.operations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.jca.archive.operations.ConnectorComponentLoadStrategyImpl;

public class ConnectorComponentNestedJARLoadStrategyImpl
extends LoadStrategyImpl {
    private List files;
    private int sourceSegmentCount;
    private int outputSegmentCount;
    private Map urisToIFiles;

    public ConnectorComponentNestedJARLoadStrategyImpl(List files, IContainer sourceContainer, IFolder javaOutputFolder) {
        this.files = files;
        this.sourceSegmentCount = sourceContainer.getProjectRelativePath().segmentCount();
        this.outputSegmentCount = javaOutputFolder.getProjectRelativePath().segmentCount();
    }

    protected boolean primContains(String uri) {
        return true;
    }

    public List getFiles() {
        this.urisToIFiles = new HashMap();
        ArrayList result = new ArrayList();
        int size = this.files.size();
        int i = 0;
        while (i < size) {
            IFile iFile = (IFile)this.files.get(i);
            IPath relPath = ConnectorComponentLoadStrategyImpl.isClass(iFile) ? this.getRelativePath(iFile, this.outputSegmentCount) : this.getRelativePath(iFile, this.sourceSegmentCount);
            this.addFile(iFile, relPath, result);
            ++i;
        }
        return result;
    }

    protected void addFile(IFile iFile, IPath relPath, List result) {
        File cFile = this.createFile(iFile, relPath);
        result.add(cFile);
        this.urisToIFiles.put(cFile.getURI(), iFile);
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    private File createFile(IFile iFile, IPath relPath) {
        File cFile = this.createFile(relPath.toString());
        cFile.setLastModified(this.getLastModified((IResource)iFile));
        return cFile;
    }

    private IPath getRelativePath(IFile file, int parentSegmentCount) {
        return file.getProjectRelativePath().removeFirstSegments(parentSegmentCount);
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        IFile file;
        if (this.urisToIFiles == null) {
            this.getFiles();
        }
        if ((file = (IFile)this.urisToIFiles.get(uri)) != null) {
            try {
                return file.getContents();
            }
            catch (CoreException core) {
                throw new ArchiveRuntimeException(uri, (Exception)((Object)core));
            }
        }
        throw new FileNotFoundException(uri);
    }
}

