/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.s.ISdkConstants;
import org.eclipse.scout.sdk.core.s.dataobject.DoContext;
import org.eclipse.scout.sdk.core.s.java.apidef.IScout22DoApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.util.CompositeObject;

public final class DoContextResolvers {
    private static volatile IDoContextResolver resolver;

    private DoContextResolvers() {
    }

    public static DoContext resolve(CharSequence targetPackage, IJavaEnvironment environment) {
        return DoContextResolvers.get().map(r -> DoContextResolvers.resolve(r, targetPackage, environment)).orElseGet(DoContext::new);
    }

    static DoContext resolve(IDoContextResolver res, CharSequence targetPackage, IJavaEnvironment environment) {
        Stream<IType> namespaceCandidates = res.resolveNamespaceCandidates(environment);
        IType namespace = DoContextResolvers.selectNamespace(targetPackage, namespaceCandidates);
        List typeVersionCandidates = Optional.ofNullable(namespace).flatMap(n -> ((IScoutApi)n.javaEnvironment().requireApi(IScoutApi.class)).api(IScout22DoApi.class)).map(doApi -> doApi.ITypeVersion().fqn()).map(iTypeVersionFqn -> res.resolvePrimaryTypesInPackageOf(namespace).flatMap(sibling -> DoContextResolvers.resolveTypeVersionCandidates(iTypeVersionFqn, sibling)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        IType typeVersion = DoContextResolvers.selectNewestTypeVersion(typeVersionCandidates);
        return new DoContext(namespace, typeVersion);
    }

    static IType selectNamespace(CharSequence refPackage, Stream<IType> candidates) {
        int bestMatch = -1;
        IType result = null;
        String[] ref = ISdkConstants.REGEX_DOT.split(refPackage);
        List<IType> namespaces = candidates.toList();
        for (IType candidate : namespaces) {
            int curMatch = DoContextResolvers.numSegmentsEquals(ref, ISdkConstants.REGEX_DOT.split(candidate.containingPackage().elementName()));
            if (curMatch <= bestMatch) continue;
            bestMatch = curMatch;
            result = candidate;
        }
        return result;
    }

    static int numSegmentsEquals(String[] a, String[] b) {
        int limit = Math.min(a.length, b.length);
        int num = 0;
        for (int i = 0; i < limit; ++i) {
            if (Objects.equals(a[i], b[i])) {
                ++num;
                continue;
            }
            return num;
        }
        return num;
    }

    static Stream<IType> resolveTypeVersionCandidates(String iTypeVersionFqn, IType sibling) {
        Stream<IType> self = Stream.of(sibling).filter(s -> s.isInstanceOf(iTypeVersionFqn));
        Stream inner = ((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)sibling.innerTypes().withRecursiveInnerTypes(true)).withInstanceOf((CharSequence)iTypeVersionFqn)).withFlags(1)).stream();
        return Stream.concat(self, inner);
    }

    static IType selectNewestTypeVersion(Iterable<IType> typeVersionCandidates) {
        Pattern pat = Pattern.compile("(\\w+?)_(\\d+(?:_\\d+)*)");
        CompositeObject curVersion = new CompositeObject(new Object[]{-1});
        IType result = null;
        for (IType candidate : typeVersionCandidates) {
            Object[] versionSegments;
            CompositeObject co;
            Matcher matcher = pat.matcher(candidate.elementName());
            if (!matcher.matches() || (co = new CompositeObject(versionSegments = Arrays.stream(matcher.group(2).split("_")).map(Integer::parseInt).toArray())).compareTo(curVersion) <= 0) continue;
            curVersion = co;
            result = candidate;
        }
        return result;
    }

    public static IDoContextResolver set(IDoContextResolver newResolver) {
        IDoContextResolver previous = resolver;
        resolver = newResolver;
        return previous;
    }

    public static Optional<IDoContextResolver> get() {
        return Optional.ofNullable(resolver);
    }

    public static interface IDoContextResolver {
        public Stream<IType> resolveNamespaceCandidates(IJavaEnvironment var1);

        public Stream<IType> resolvePrimaryTypesInPackageOf(IType var1);
    }
}

