/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.OrderedInfixExpression;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.ControlWorkflowMatcher;
import org.eclipse.jdt.internal.corext.util.ControlWorkflowMatcherRunnable;
import org.eclipse.jdt.internal.corext.util.NodeMatcher;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class ComparingOnCriteriaCleanUpCore
extends AbstractMultiFix {
    public ComparingOnCriteriaCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ComparingOnCriteriaCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.comparing_on_criteria");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.comparing_on_criteria")) {
            return new String[]{MultiFixMessages.ComparingOnCriteriaCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.comparing_on_criteria")) {
            return "Comparator<Date> comparator = Comparator.nullsFirst(Comparator.comparing(Date::toString));\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
        }
        return "Comparator<Date> comparator = new Comparator<Date>() {\n    @Override\n    public int compare(Date o1, Date o2) {\n        if (o2 != null) {\n            if (o1 != null) {\n                return o1.toString().compareTo(o2.toString());\n            }\n            return -1;\n        } else if (o1 != null) {\n            return 1;\n        } else {\n            return 0;\n        }\n    }\n};\n";
    }

    private static boolean equalNotNull(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.comparing_on_criteria")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(LambdaExpression visited) {
                ITypeBinding targetType = ASTNodes.getTargetType((Expression)visited);
                if (ASTNodes.hasType(targetType, Comparator.class.getCanonicalName()) && targetType.getTypeArguments() != null && targetType.getTypeArguments().length == 1 && visited.parameters() != null && visited.parameters().size() == 2) {
                    VariableDeclaration object1 = (VariableDeclaration)visited.parameters().get(0);
                    VariableDeclaration object2 = (VariableDeclaration)visited.parameters().get(1);
                    if (visited.getBody() instanceof Statement) {
                        return this.maybeRefactorBody((Expression)visited, targetType.getTypeArguments()[0], object1, object2, ASTNodes.asList((Statement)visited.getBody()));
                    }
                    if (visited.getBody() instanceof Expression) {
                        SimpleName name1 = object1.getName();
                        SimpleName name2 = object2.getName();
                        return this.maybeRefactorExpression((Expression)visited, targetType.getTypeArguments()[0], name1, name2, (Expression)visited.getBody());
                    }
                }
                return true;
            }

            public boolean visit(ClassInstanceCreation visited) {
                AnonymousClassDeclaration anonymousClassDecl = visited.getAnonymousClassDeclaration();
                Type type = visited.getType();
                if (type != null && type.resolveBinding() != null && type.resolveBinding().getTypeArguments() != null && type.resolveBinding().getTypeArguments().length == 1 && ASTNodes.hasType(type.resolveBinding(), Comparator.class.getCanonicalName()) && visited.arguments().isEmpty() && anonymousClassDecl != null && anonymousClassDecl.bodyDeclarations() != null && anonymousClassDecl.bodyDeclarations().size() == 1) {
                    BodyDeclaration body;
                    List bodies = anonymousClassDecl.bodyDeclarations();
                    ITypeBinding typeArgument = type.resolveBinding().getTypeArguments()[0];
                    if (bodies != null && bodies.size() == 1 && typeArgument != null && (body = (BodyDeclaration)bodies.get(0)) instanceof MethodDeclaration) {
                        return this.maybeRefactorMethod(visited, typeArgument, (MethodDeclaration)body);
                    }
                }
                return true;
            }

            private boolean maybeRefactorMethod(ClassInstanceCreation visited, ITypeBinding typeArgument, MethodDeclaration methodDecl) {
                Block methodBody = methodDecl.getBody();
                if (ASTNodes.usesGivenSignature(methodDecl, Comparator.class.getCanonicalName(), "compare", typeArgument.getQualifiedName(), typeArgument.getQualifiedName())) {
                    VariableDeclaration object1 = (VariableDeclaration)methodDecl.parameters().get(0);
                    VariableDeclaration object2 = (VariableDeclaration)methodDecl.parameters().get(1);
                    List statements = methodBody.statements();
                    return this.maybeRefactorBody((Expression)visited, typeArgument, object1, object2, statements);
                }
                return true;
            }

            private boolean maybeRefactorBody(Expression visited, ITypeBinding typeArgument, VariableDeclaration object1, VariableDeclaration object2, List<Statement> statements) {
                SimpleName name2;
                final SimpleName name1 = object1.getName();
                if (!this.maybeRefactorCompareToMethod(visited, typeArgument, statements, name1, name2 = object2.getName())) {
                    return false;
                }
                final AtomicReference<Expression> criteria = new AtomicReference<Expression>();
                final AtomicBoolean isForward = new AtomicBoolean(true);
                NodeMatcher<Expression> compareToMatcher = new NodeMatcher<Expression>(){

                    @Override
                    public Boolean isMatching(Expression node) {
                        if (this.isReturnedExpressionToRefactor(node, criteria, isForward, name1, name2)) {
                            return Boolean.TRUE;
                        }
                        return null;
                    }
                };
                NodeMatcher<Expression> zeroMatcher = new NodeMatcher<Expression>(){

                    @Override
                    public Boolean isMatching(Expression node) {
                        if (Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral(node))) {
                            return Boolean.TRUE;
                        }
                        return null;
                    }
                };
                NodeMatcher<Expression> positiveMatcher = new NodeMatcher<Expression>(){

                    @Override
                    public Boolean isMatching(Expression node) {
                        Long value = ASTNodes.getIntegerLiteral(node);
                        if (value != null && value > 0L) {
                            return Boolean.TRUE;
                        }
                        return null;
                    }
                };
                NodeMatcher<Expression> negativeMatcher = new NodeMatcher<Expression>(){

                    @Override
                    public Boolean isMatching(Expression node) {
                        Long value = ASTNodes.getIntegerLiteral(node);
                        if (value != null && value < 0L) {
                            return Boolean.TRUE;
                        }
                        return null;
                    }
                };
                ControlWorkflowMatcherRunnable runnableMatcher = ControlWorkflowMatcher.createControlWorkflowMatcher().addWorkflow(new ObjectNotNullMatcher(name1)).condition(new ObjectNotNullMatcher(name2)).returnedValue(compareToMatcher).addWorkflow(new ObjectNotNullMatcher(name1).negate()).condition(new ObjectNotNullMatcher(name2).negate()).returnedValue(zeroMatcher).addWorkflow(new ObjectNotNullMatcher(name1).negate()).condition(new ObjectNotNullMatcher(name2)).returnedValue(negativeMatcher).addWorkflow(new ObjectNotNullMatcher(name1)).condition(new ObjectNotNullMatcher(name2).negate()).returnedValue(positiveMatcher);
                if (runnableMatcher.isMatching(statements)) {
                    rewriteOperations.add(new ComparingOnCriteriaOperation(visited, typeArgument, name1, criteria, isForward, Boolean.TRUE));
                    return false;
                }
                runnableMatcher = ControlWorkflowMatcher.createControlWorkflowMatcher().addWorkflow(new ObjectNotNullMatcher(name1)).condition(new ObjectNotNullMatcher(name2)).returnedValue(compareToMatcher).addWorkflow(new ObjectNotNullMatcher(name1).negate()).condition(new ObjectNotNullMatcher(name2).negate()).returnedValue(zeroMatcher).addWorkflow(new ObjectNotNullMatcher(name1)).condition(new ObjectNotNullMatcher(name2).negate()).returnedValue(negativeMatcher).addWorkflow(new ObjectNotNullMatcher(name1).negate()).condition(new ObjectNotNullMatcher(name2)).returnedValue(positiveMatcher);
                if (runnableMatcher.isMatching(statements)) {
                    rewriteOperations.add(new ComparingOnCriteriaOperation(visited, typeArgument, name1, criteria, isForward, Boolean.FALSE));
                    return false;
                }
                return true;
            }

            private boolean maybeRefactorCompareToMethod(Expression visited, ITypeBinding typeArgument, List<Statement> statements, SimpleName name1, SimpleName name2) {
                ReturnStatement returnStatement;
                if (statements != null && statements.size() == 1 && (returnStatement = ASTNodes.as(statements.get(0), ReturnStatement.class)) != null) {
                    return this.maybeRefactorExpression(visited, typeArgument, name1, name2, returnStatement.getExpression());
                }
                return true;
            }

            private boolean maybeRefactorExpression(Expression visited, ITypeBinding typeArgument, SimpleName name1, SimpleName name2, Expression expression) {
                AtomicReference<Expression> criteria = new AtomicReference<Expression>();
                AtomicBoolean isForward = new AtomicBoolean(true);
                if (this.isReturnedExpressionToRefactor(expression, criteria, isForward, name1, name2)) {
                    rewriteOperations.add(new ComparingOnCriteriaOperation(visited, typeArgument, name1, criteria, isForward, null));
                    return false;
                }
                return true;
            }

            private boolean isComparable(ITypeBinding classBinding) {
                if ("java.lang.Comparable".equals(classBinding.getErasure().getQualifiedName())) {
                    return true;
                }
                ITypeBinding superClass = classBinding.getSuperclass();
                if (superClass != null && this.isComparable(superClass)) {
                    return true;
                }
                ITypeBinding[] iTypeBindingArray = classBinding.getInterfaces();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding binding = iTypeBindingArray[n2];
                    if (this.isComparable(binding)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            private boolean isReturnedExpressionToRefactor(Expression returnExpression, AtomicReference<Expression> criteria, AtomicBoolean isForward, SimpleName name1, SimpleName name2) {
                ITypeBinding comparisonType;
                PrefixExpression negativeExpression = ASTNodes.as(returnExpression, PrefixExpression.class);
                if (negativeExpression != null && ASTNodes.hasOperator(negativeExpression, PrefixExpression.Operator.MINUS, new PrefixExpression.Operator[0])) {
                    isForward.lazySet(!isForward.get());
                    return this.isReturnedExpressionToRefactor(negativeExpression.getOperand(), criteria, isForward, name1, name2);
                }
                MethodInvocation compareToMethod = ASTNodes.as(returnExpression, MethodInvocation.class);
                if (compareToMethod != null && compareToMethod.getExpression() != null && (comparisonType = compareToMethod.getExpression().resolveTypeBinding()) != null && this.isComparable(comparisonType)) {
                    if (compareToMethod.getExpression() != null && ASTNodes.usesGivenSignature(compareToMethod, comparisonType.getQualifiedName(), "compareTo", comparisonType.getQualifiedName())) {
                        return this.isRefactorComparisonToRefactor(criteria, isForward, name1, name2, compareToMethod.getExpression(), (Expression)compareToMethod.arguments().get(0));
                    }
                    String primitiveType = Bindings.getUnboxedTypeName(comparisonType.getQualifiedName());
                    if (primitiveType != null && ASTNodes.usesGivenSignature(compareToMethod, comparisonType.getQualifiedName(), "compare", primitiveType, primitiveType)) {
                        return this.isRefactorComparisonToRefactor(criteria, isForward, name1, name2, (Expression)compareToMethod.arguments().get(0), (Expression)compareToMethod.arguments().get(1));
                    }
                }
                return false;
            }

            private boolean isRefactorComparisonToRefactor(AtomicReference<Expression> criteria, AtomicBoolean isForward, SimpleName name1, SimpleName name2, Expression expr1, Expression expr2) {
                MethodInvocation method1 = ASTNodes.as(expr1, MethodInvocation.class);
                MethodInvocation method2 = ASTNodes.as(expr2, MethodInvocation.class);
                QualifiedName field1 = ASTNodes.as(expr1, QualifiedName.class);
                QualifiedName field2 = ASTNodes.as(expr2, QualifiedName.class);
                if (method1 != null && method1.arguments().isEmpty() && method2 != null && method2.arguments().isEmpty()) {
                    String methodName1 = method1.getName().getIdentifier();
                    String methodName2 = method2.getName().getIdentifier();
                    SimpleName objectExpr1 = ASTNodes.as(method1.getExpression(), SimpleName.class);
                    SimpleName objectExpr2 = ASTNodes.as(method2.getExpression(), SimpleName.class);
                    if (ComparingOnCriteriaCleanUpCore.equalNotNull(methodName1, methodName2) && objectExpr1 != null && objectExpr2 != null) {
                        if (ASTNodes.isSameVariable((ASTNode)objectExpr1, (ASTNode)name1) && ASTNodes.isSameVariable((ASTNode)objectExpr2, (ASTNode)name2)) {
                            criteria.set((Expression)method1);
                            return true;
                        }
                        if (ASTNodes.isSameVariable((ASTNode)objectExpr1, (ASTNode)name2) && ASTNodes.isSameVariable((ASTNode)objectExpr2, (ASTNode)name1)) {
                            criteria.set((Expression)method1);
                            isForward.lazySet(!isForward.get());
                            return true;
                        }
                    }
                } else if (field1 != null && field2 != null) {
                    SimpleName fieldName1 = field1.getName();
                    SimpleName fieldName2 = field2.getName();
                    SimpleName objectExpr1 = ASTNodes.as((Expression)field1.getQualifier(), SimpleName.class);
                    SimpleName objectExpr2 = ASTNodes.as((Expression)field2.getQualifier(), SimpleName.class);
                    if (ASTNodes.isSameVariable((ASTNode)fieldName1, (ASTNode)fieldName2) && objectExpr1 != null && objectExpr2 != null) {
                        if (ASTNodes.isSameVariable((ASTNode)objectExpr1, (ASTNode)name1) && ASTNodes.isSameVariable((ASTNode)objectExpr2, (ASTNode)name2)) {
                            criteria.set((Expression)field1);
                            return true;
                        }
                        if (ASTNodes.isSameVariable((ASTNode)objectExpr1, (ASTNode)name2) && ASTNodes.isSameVariable((ASTNode)objectExpr2, (ASTNode)name1)) {
                            criteria.set((Expression)field1);
                            isForward.lazySet(!isForward.get());
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.ComparingOnCriteriaCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class ComparingOnCriteriaOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Expression visited;
        private final ITypeBinding typeArgument;
        private final SimpleName name1;
        private final AtomicReference<Expression> criteria;
        private final AtomicBoolean isForward;
        private final Boolean isNullFirst;

        public ComparingOnCriteriaOperation(Expression visited, ITypeBinding typeArgument, SimpleName name1, AtomicReference<Expression> criteria, AtomicBoolean isForward, Boolean isNullFirst) {
            this.visited = visited;
            this.typeArgument = typeArgument;
            this.name1 = name1;
            this.criteria = criteria;
            this.isForward = isForward;
            this.isNullFirst = isNullFirst;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            MethodInvocation newMethodInvocation;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ComparingOnCriteriaCleanUp_description, cuRewrite);
            String comparatorNameText = importRewrite.addImport(Comparator.class.getCanonicalName());
            Object lambda = this.criteria.get() instanceof MethodInvocation ? this.buildMethod(this.typeArgument, (MethodInvocation)this.criteria.get(), rewrite, ast, importRewrite) : this.buildField(this.visited, this.typeArgument, this.isForward.get(), this.isNullFirst, (QualifiedName)this.criteria.get(), this.name1, rewrite, ast, importRewrite);
            MethodInvocation comparingMethod = ast.newMethodInvocation();
            comparingMethod.setExpression((Expression)ASTNodeFactory.newName(ast, comparatorNameText));
            comparingMethod.setName(ast.newSimpleName("comparing"));
            comparingMethod.arguments().add(lambda);
            if (!this.isForward.get()) {
                newMethodInvocation = ast.newMethodInvocation();
                newMethodInvocation.setExpression((Expression)comparingMethod);
                newMethodInvocation.setName(ast.newSimpleName("reversed"));
                comparingMethod = newMethodInvocation;
            }
            if (this.isNullFirst != null) {
                newMethodInvocation = ast.newMethodInvocation();
                newMethodInvocation.setExpression((Expression)ASTNodeFactory.newName(ast, comparatorNameText));
                newMethodInvocation.setName(ast.newSimpleName(this.isNullFirst != false ? "nullsFirst" : "nullsLast"));
                newMethodInvocation.arguments().add(comparingMethod);
                comparingMethod = newMethodInvocation;
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)comparingMethod, group);
        }

        private TypeMethodReference buildMethod(ITypeBinding type, MethodInvocation method, ASTRewrite rewrite, AST ast, ImportRewrite importRewrite) {
            TypeMethodReference typeMethodRef = ast.newTypeMethodReference();
            if (type.isWildcardType()) {
                ITypeBinding bound = type.getBound();
                Type boundType = importRewrite.addImport(bound, ast, importRewrite.getDefaultImportRewriteContext(), ImportRewrite.TypeLocation.TYPE_BOUND);
                typeMethodRef.setType(boundType);
            } else {
                String comparedClassNameText = importRewrite.addImport(type.getErasure());
                typeMethodRef.setType((Type)ast.newSimpleType(ASTNodeFactory.newName(ast, comparedClassNameText)));
            }
            typeMethodRef.setName(ASTNodes.createMoveTarget(rewrite, method.getName()));
            return typeMethodRef;
        }

        private LambdaExpression buildField(Expression node, ITypeBinding type, boolean straightOrder, Boolean isNullValuesFirst, QualifiedName field, SimpleName name, ASTRewrite rewrite, AST ast, ImportRewrite importRewrite) {
            boolean isTypeKnown;
            LambdaExpression lambdaExpression = ast.newLambdaExpression();
            ITypeBinding destinationType = ASTNodes.getTargetType(node);
            boolean bl = isTypeKnown = destinationType != null && ASTNodes.hasType(destinationType, Comparator.class.getCanonicalName()) && destinationType.getTypeArguments() != null && destinationType.getTypeArguments().length == 1 && ComparingOnCriteriaCleanUpCore.equalNotNull(destinationType.getTypeArguments()[0], type);
            if (isTypeKnown && straightOrder && isNullValuesFirst == null) {
                VariableDeclarationFragment newVariableDeclarationFragment = ast.newVariableDeclarationFragment();
                newVariableDeclarationFragment.setName((SimpleName)rewrite.createCopyTarget((ASTNode)name));
                lambdaExpression.parameters().add(newVariableDeclarationFragment);
            } else {
                String comparedClassNameText;
                String importedName = comparedClassNameText = importRewrite.addImport(type);
                SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
                if (type.isWildcardType()) {
                    ITypeBinding bound = type.getBound();
                    Type boundType = importRewrite.addImport(bound, ast, importRewrite.getDefaultImportRewriteContext(), ImportRewrite.TypeLocation.TYPE_BOUND);
                    newSingleVariableDeclaration.setType(boundType);
                    if (bound.isLocal()) {
                        importRewrite.removeImport(bound.getQualifiedName());
                    }
                    importedName = bound.getQualifiedName();
                } else {
                    newSingleVariableDeclaration.setType((Type)ast.newSimpleType(ASTNodeFactory.newName(ast, comparedClassNameText)));
                }
                newSingleVariableDeclaration.setName((SimpleName)rewrite.createCopyTarget((ASTNode)name));
                lambdaExpression.parameters().add(newSingleVariableDeclaration);
                if (type.isLocal()) {
                    importRewrite.removeImport(importedName);
                } else {
                    try {
                        IType[] cuTypes;
                        IType[] iTypeArray = cuTypes = importRewrite.getCompilationUnit().getTypes();
                        int n = cuTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType cuType = iTypeArray[n2];
                            if (importedName.startsWith(cuType.getFullyQualifiedName())) {
                                importRewrite.removeImport(importedName);
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
            FieldAccess newFieldAccess = ast.newFieldAccess();
            newFieldAccess.setExpression((Expression)((SimpleName)rewrite.createCopyTarget((ASTNode)name)));
            newFieldAccess.setName(ASTNodes.createMoveTarget(rewrite, field.getName()));
            lambdaExpression.setBody((ASTNode)newFieldAccess);
            lambdaExpression.setParentheses(false);
            return lambdaExpression;
        }
    }

    private static final class ObjectNotNullMatcher
    extends NodeMatcher<Expression> {
        private final SimpleName name;

        private ObjectNotNullMatcher(SimpleName name) {
            this.name = name;
        }

        @Override
        public Boolean isMatching(Expression node) {
            OrderedInfixExpression<SimpleName, NullLiteral> orderedInfix;
            InfixExpression condition = ASTNodes.as(node, InfixExpression.class);
            if (condition != null && ASTNodes.hasOperator(condition, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS) && (orderedInfix = ASTNodes.orderedInfix((Expression)condition, SimpleName.class, NullLiteral.class)) != null && ASTNodes.isSameVariable((ASTNode)orderedInfix.getFirstOperand(), (ASTNode)this.name) && ASTNodes.isPassive((ASTNode)orderedInfix.getFirstOperand())) {
                return ASTNodes.hasOperator(condition, InfixExpression.Operator.NOT_EQUALS, new InfixExpression.Operator[0]);
            }
            return null;
        }
    }
}

