/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.zoom;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.zoom.DefaultScrollPolicy;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class MouseLocationZoomScrollPolicy
extends DefaultScrollPolicy {
    final Control viewerControl;

    public MouseLocationZoomScrollPolicy(Control viewerControl) {
        this.viewerControl = viewerControl;
    }

    @Override
    public Point calcNewViewLocation(Viewport vp, double oldZoom, double newZoom) {
        Rectangle controlBounds = this.viewerControl.getBounds();
        org.eclipse.swt.graphics.Point mouseLocation = this.viewerControl.getDisplay().getCursorLocation();
        if (controlBounds.contains(mouseLocation = this.viewerControl.toControl(mouseLocation))) {
            return MouseLocationZoomScrollPolicy.calcMouseBasedViewLocation(vp, oldZoom, newZoom, new Point(mouseLocation));
        }
        return super.calcNewViewLocation(vp, oldZoom, newZoom);
    }

    private static Point calcMouseBasedViewLocation(Viewport vp, double oldZoom, double newZoom, Point mouseLocation) {
        Point oldViewLocation = vp.getViewLocation();
        Point newviewLocation = mouseLocation.getCopy();
        newviewLocation.performTranslate(oldViewLocation.x, oldViewLocation.y);
        newviewLocation.scale(newZoom / oldZoom);
        newviewLocation.performTranslate(-mouseLocation.x, -mouseLocation.y);
        return newviewLocation;
    }
}

