/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.converter.ui.contribution.ModelConverterDescriptor;
import org.eclipse.emf.converter.ui.contribution.ModelConverterManager;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.jface.wizard.IWizard;

public class ModelImporterManager
extends ModelConverterManager<ModelImporterDescriptor> {
    public static final ModelImporterManager INSTANCE = new ModelImporterManager();
    private static List<String> DEFAULT_IMPORTER_IDS = Arrays.asList("org.eclipse.emf.importer.ecore", "org.eclipse.emf.importer.java", "org.eclipse.emf.importer.rose", "org.eclipse.xsd.ecore.importer", "org.eclipse.emf.ecore.xcoreimporter");

    protected String getPluginId() {
        return "org.eclipse.emf.importer";
    }

    protected String getExtensionPointId() {
        return "modelImporterDescriptors";
    }

    protected String getElementName() {
        return "modelImporterDescriptor";
    }

    protected ModelImporterDescriptorImpl createModelConverterDescriptorImpl() {
        return new ModelImporterDescriptorImpl();
    }

    protected ModelImporterDescriptorWizardNode createModelConverterDescriptorWizardNode(ModelImporterDescriptor descriptor) {
        return new ModelImporterDescriptorWizardNode(descriptor);
    }

    public ModelImporterDescriptor getModelImporterDescriptor(String id) {
        return (ModelImporterDescriptor)this.getModelConverterDescriptor(id);
    }

    public ModelImporterDescriptor createFromContribution(IConfigurationElement configurationElement) {
        ModelImporterDescriptorImpl descriptorImpl = (ModelImporterDescriptorImpl)super.createFromContribution(configurationElement);
        if (descriptorImpl != null) {
            String typesAttribute;
            String extensions = configurationElement.getAttribute("extensions");
            if (extensions != null) {
                String[] exts = extensions.split(",");
                int i = 0;
                while (i < exts.length) {
                    String ext = exts[i].trim();
                    if (ext.length() > 0) {
                        descriptorImpl.getExtensions().add(ext);
                    }
                    ++i;
                }
            }
            if ((typesAttribute = configurationElement.getAttribute("types")) != null) {
                descriptorImpl.setTypes(0);
                String[] types = typesAttribute.split(",");
                int i = 0;
                while (i < types.length) {
                    String type = types[i].trim();
                    if ("project".equalsIgnoreCase(type)) {
                        descriptorImpl.setTypes(descriptorImpl.getTypes() | 1);
                    } else if ("file".equalsIgnoreCase(type)) {
                        descriptorImpl.setTypes(descriptorImpl.getTypes() | 2);
                    }
                    ++i;
                }
            }
        }
        return descriptorImpl;
    }

    public List<ModelImporterDescriptor> filterModelImporterDescriptors(int type) {
        ArrayList<ModelImporterDescriptor> descriptors = new ArrayList<ModelImporterDescriptor>();
        for (ModelImporterDescriptor descriptor : this.getModelConverterDescriptors()) {
            if ((descriptor.getTypes() & type) != type) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<ModelImporterDescriptor> filterModelImporterDescriptors(String extension) {
        ArrayList<ModelImporterDescriptor> descriptors = new ArrayList<ModelImporterDescriptor>();
        for (ModelImporterDescriptor descriptor : this.getModelConverterDescriptors()) {
            if (!descriptor.getExtensions().contains(extension)) continue;
            if (DEFAULT_IMPORTER_IDS.contains(descriptor.getID())) {
                descriptors.add(0, descriptor);
                continue;
            }
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static class ModelImporterDescriptorImpl
    extends ModelConverterManager.ModelConverterDescriptorImpl
    implements ModelImporterDescriptor {
        protected List<String> extensions;
        protected int types = 3;

        @Override
        public IModelImporterWizard createWizard() {
            Object object = this.createExecutableExtension("wizard");
            return object instanceof IModelImporterWizard ? (IModelImporterWizard)object : null;
        }

        @Override
        public int getTypes() {
            return this.types;
        }

        public void setTypes(int types) {
            this.types = types;
        }

        @Override
        public List<String> getExtensions() {
            if (this.extensions == null) {
                this.extensions = new ArrayList<String>();
            }
            return this.extensions;
        }
    }

    public static class ModelImporterDescriptorWizardNode
    extends ModelConverterManager.ModelConverterDescriptorWizardNode {
        public ModelImporterDescriptorWizardNode(ModelImporterDescriptor descriptor) {
            super((ModelConverterDescriptor)descriptor);
        }

        protected IWizard createWizard() {
            return ((ModelImporterDescriptor)this.descriptor).createWizard();
        }
    }
}

