/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.osgi.framework.Bundle;

public final class FileUtil {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String FILE_DOT_PROJECT = ".project";

    private FileUtil() {
    }

    public static void validateEdit(IFile ... files) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IStatus st = ws.validateEdit(files, IWorkspace.VALIDATE_PROMPT);
        if (st.getSeverity() == 4) {
            throw new CoreException(st);
        }
    }

    public static boolean validateEdit(Set<IFile> files) {
        IFile[] filesArray = files.toArray(new IFile[files.size()]);
        Arrays.sort(filesArray, new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                String path1 = file1.getFullPath().toOSString();
                String path2 = file2.getFullPath().toOSString();
                return path1.compareTo(path2);
            }
        });
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IStatus st = ws.validateEdit(filesArray, IWorkspace.VALIDATE_PROMPT);
        return st.getSeverity() != 4;
    }

    public static void copyFromPlugin(String pluginId, IPath pathInPlugin, IFile destination) throws CoreException {
        FileUtil.copyFromPlugin(pluginId, pathInPlugin, destination.getLocation().toFile());
    }

    public static void copyFromPlugin(Bundle bundle, IPath pathInPlugin, IFile destination) throws CoreException {
        FileUtil.copyFromPlugin(bundle, pathInPlugin, destination.getLocation().toFile());
    }

    public static void copyFromPlugin(String pluginId, IPath pathInPlugin, File destination) throws CoreException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        FileUtil.copyFromPlugin(bundle, pathInPlugin, destination);
    }

    public static void copyFromPlugin(Bundle bundle, IPath pathInPlugin, File destination) throws CoreException {
        InputStream contents = FileUtil.readFileFromPlugin(bundle, pathInPlugin);
        try {
            FileUtil.writeFile(destination, contents);
        }
        catch (Throwable throwable) {
            try {
                contents.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            contents.close();
        }
        catch (Exception exception) {}
    }

    public static InputStream readFileFromPlugin(Bundle bundle, IPath pathInPlugin) throws CoreException {
        try {
            return FileLocator.openStream((Bundle)bundle, (IPath)pathInPlugin, (boolean)false);
        }
        catch (IOException e) {
            throw new CoreException(FacetCorePlugin.createErrorStatus(e.getMessage(), e));
        }
    }

    public static IFile getWorkspaceFile(File f) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IFile[] wsFiles = wsroot.findFilesForLocation((IPath)(path = new Path(f.getAbsolutePath())));
        if (wsFiles.length > 0) {
            return wsFiles[0];
        }
        return null;
    }

    public static IContainer getWorkspaceContainer(File f) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IContainer[] wsContainers = wsroot.findContainersForLocation((IPath)(path = new Path(f.getAbsolutePath())));
        if (wsContainers.length > 0) {
            return wsContainers[0];
        }
        return null;
    }

    public static void mkdirs(File f) throws CoreException {
        if (f.exists()) {
            if (f.isFile()) {
                String msg = NLS.bind((String)Resources.locationIsFile, (Object)f.getAbsolutePath());
                throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
            IContainer wsContainer = FileUtil.getWorkspaceContainer(f);
            if (wsContainer != null) {
                IFolder iFolder = (IFolder)wsContainer;
                iFolder.create(true, true, null);
            } else {
                boolean isSuccessful = f.mkdir();
                if (!isSuccessful) {
                    String msg = NLS.bind((String)Resources.failedToCreateDirectory, (Object)f.getAbsolutePath());
                    throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
                }
            }
        }
    }

    public static void writeFile(IFile f, String contents) throws CoreException {
        FileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(IFile f, byte[] contents) throws CoreException {
        FileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(IFile f, InputStream contents) throws CoreException {
        FileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(File f, String contents) throws CoreException {
        try {
            FileUtil.writeFile(f, contents.getBytes(UTF8_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File f, byte[] contents) throws CoreException {
        FileUtil.writeFile(f, (InputStream)new ByteArrayInputStream(contents));
    }

    public static void writeFile(File f, InputStream contents) throws CoreException {
        IFile wsfile;
        if (f.exists()) {
            if (f.isDirectory()) {
                String msg = NLS.bind((String)Resources.locationIsDirectory, (Object)f.getAbsolutePath());
                throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
            }
        } else {
            FileUtil.mkdirs(f.getParentFile());
        }
        if ((wsfile = FileUtil.getWorkspaceFile(f)) != null) {
            FileUtil.validateEdit(wsfile);
            if (wsfile.exists()) {
                wsfile.setContents(contents, true, false, null);
            } else {
                wsfile.create(contents, true, null);
            }
        } else {
            if (f.exists() && !f.canWrite()) {
                String msg = NLS.bind((String)Resources.cannotWriteFile, (Object)f.getAbsolutePath());
                throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
            }
            byte[] buffer = new byte[1024];
            FileOutputStream out = null;
            try {
                try {
                    int count;
                    out = new FileOutputStream(f);
                    while ((count = contents.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)Resources.failedWhileWriting, (Object)f.getAbsolutePath());
                    throw new CoreException(FacetCorePlugin.createErrorStatus(msg, e));
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteFile(File file) throws CoreException {
        IFile wsfile = FileUtil.getWorkspaceFile(file);
        if (wsfile != null) {
            wsfile.delete(true, null);
        } else {
            file.delete();
        }
    }

    private static final class Resources
    extends NLS {
        public static String failedWhileWriting;
        public static String cannotWriteFile;
        public static String failedToCreateDirectory;
        public static String locationIsDirectory;
        public static String locationIsFile;

        static {
            Resources.initializeMessages((String)FileUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

