/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ViewerUpdateMonitor
extends Request
implements IViewerUpdate {
    private final TreeModelContentProvider fContentProvider;
    private final TreePath fElementPath;
    private final Object fElement;
    private final IElementContentProvider fElementContentProvider;
    private boolean fDone = false;
    private boolean fStarted = false;
    private Object fViewerInput = null;
    private boolean fIsDelegated = false;
    private final IPresentationContext fContext;

    /*
     * WARNING - void declaration
     */
    public ViewerUpdateMonitor(TreeModelContentProvider contentProvider, Object viewerInput, TreePath elementPath, Object element, IElementContentProvider elementContentProvider, IPresentationContext context) {
        this.fContext = context;
        if (viewerInput == null) {
            IWorkbenchPart iWorkbenchPart = context.getPart();
            if (!(iWorkbenchPart instanceof VariablesView)) {
                DebugUIPlugin.log(new NullPointerException("Input to viewer update should not be null"));
            } else {
                void view;
                VariablesView variablesView = (VariablesView)iWorkbenchPart;
                IViewerInputUpdate viewerUpdate = view.getLastViewerUpdate();
                if (viewerUpdate == null || viewerUpdate.getElement() != ViewerInputService.NULL_INPUT) {
                    DebugUIPlugin.log(new NullPointerException("Input element in viewer update should not be null: " + String.valueOf(viewerUpdate)));
                }
            }
        }
        this.fViewerInput = viewerInput;
        this.fElementContentProvider = elementContentProvider;
        this.fContentProvider = contentProvider;
        this.fElement = element;
        this.fElementPath = elementPath;
    }

    protected ISchedulingRule getUpdateSchedulingRule() {
        return AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(this.getContentProvider());
    }

    protected TreeModelContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    protected IElementContentProvider getElementContentProvider() {
        return this.fElementContentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void done() {
        ViewerUpdateMonitor viewerUpdateMonitor = this;
        synchronized (viewerUpdateMonitor) {
            if (this.isDone()) {
                return;
            }
            this.fDone = true;
        }
        this.scheduleViewerUpdate();
    }

    protected synchronized boolean isDone() {
        return this.fDone;
    }

    protected void scheduleViewerUpdate() {
        this.getContentProvider().scheduleViewerUpdate(this);
    }

    protected abstract void performUpdate();

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    @Override
    public Object getElement() {
        return this.fElement;
    }

    @Override
    public TreePath getElementPath() {
        return this.fElementPath;
    }

    abstract boolean coalesce(ViewerUpdateMonitor var1);

    abstract boolean containsUpdate(TreePath var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        ViewerUpdateMonitor viewerUpdateMonitor = this;
        synchronized (viewerUpdateMonitor) {
            if (this.fStarted) {
                return;
            }
            this.fStarted = true;
        }
        this.getContentProvider().updateStarted(this);
        if (!this.isCanceled()) {
            this.startRequest();
        } else {
            this.done();
        }
    }

    @Override
    public Object getViewerInput() {
        return this.fViewerInput;
    }

    abstract void startRequest();

    abstract int getPriority();

    abstract TreePath getSchedulingPath();

    public void setDelegated(boolean delegated) {
        this.fIsDelegated = delegated;
    }

    public boolean isDelegated() {
        return this.fIsDelegated;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ViewerUpdateMonitor) {
            return this.doEquals((ViewerUpdateMonitor)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.doHashCode();
    }

    protected abstract boolean doEquals(ViewerUpdateMonitor var1);

    protected abstract int doHashCode();

    protected void execInDisplayThread(Runnable runnable) {
        IInternalTreeModelViewer viewer = this.getContentProvider().getViewer();
        if (viewer != null && !this.isCanceled()) {
            Display display = viewer.getDisplay();
            if (Thread.currentThread() == display.getThread()) {
                runnable.run();
            } else {
                display.asyncExec(runnable);
            }
        }
    }
}

