/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;

public class LambdaCollector
extends ASTVisitor {
    private final int fLineOffset;
    private final int fLineEndPosition;
    private final List<LambdaExpression> lambdaExpressions;

    public LambdaCollector(int lineOffset, int lineEndPosition) {
        this.fLineOffset = lineOffset;
        this.fLineEndPosition = lineEndPosition;
        this.lambdaExpressions = new ArrayList<LambdaExpression>();
    }

    public boolean visit(LambdaExpression node) {
        if (node.getStartPosition() < this.fLineOffset || node.getStartPosition() > this.fLineEndPosition) {
            return false;
        }
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding != null) {
            this.lambdaExpressions.add(node);
        }
        return false;
    }

    public List<LambdaExpression> getLambdaExpressions() {
        return this.lambdaExpressions;
    }
}

