/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.egit.internal.ui.commit;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;

public class TaskReferenceFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_TYPES = new Class[]{AbstractTaskReference.class};
    private static final String BUGTRACK_SECTION = "bugtracker";
    private static final String BUGTRACK_URL = "url";
    private static final String LOCALHOST = "localhost";

    public Class<?>[] getAdapterList() {
        Class[] c = new Class[ADAPTER_TYPES.length];
        System.arraycopy(ADAPTER_TYPES, 0, c, 0, c.length);
        return c;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!AbstractTaskReference.class.equals(adapterType)) {
            return null;
        }
        return adapterType.cast(this.adaptFromObject(adaptableObject));
    }

    private AbstractTaskReference adaptFromObject(Object element) {
        IRepositoryCommit commit = TaskReferenceFactory.getCommitForElement(element);
        if (commit != null) {
            return this.adaptFromCommit(commit);
        }
        return null;
    }

    private AbstractTaskReference adaptFromCommit(IRepositoryCommit commit) {
        Repository r = commit.getRepository();
        TaskRepository repository = this.getTaskRepository(r);
        if (repository == null) {
            return null;
        }
        String taskRepositoryUrl = repository.getRepositoryUrl();
        String message = null;
        long timestamp = 0L;
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (RevWalk revWalk = new RevWalk(r);){
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commit.getRevCommit());
                message = revCommit.getFullMessage();
                timestamp = (long)revCommit.getCommitTime() * 1000L;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            return null;
        }
        if (message == null || message.trim().isEmpty()) {
            return null;
        }
        return new LinkedTaskInfo(taskRepositoryUrl, null, null, message, timestamp);
    }

    private static IRepositoryCommit getCommitForElement(Object element) {
        if (element instanceof IRepositoryCommit) {
            return (IRepositoryCommit)element;
        }
        if (element instanceof GitModelCommit) {
            GitModelCommit modelCommit = (GitModelCommit)element;
            if (!(modelCommit.getParent() instanceof GitModelRepository)) {
                return null;
            }
            GitModelRepository parent = (GitModelRepository)modelCommit.getParent();
            final Repository repo = parent.getRepository();
            AbbreviatedObjectId id = modelCommit.getCachedCommitObj().getId();
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk rw = new RevWalk(repo);){
                final RevCommit commit = rw.lookupCommit((AnyObjectId)id.toObjectId());
                return new IRepositoryCommit(){

                    public Repository getRepository() {
                        return repo;
                    }

                    public RevCommit getRevCommit() {
                        return commit;
                    }
                };
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private TaskRepository getTaskRepository(Repository repository) {
        StoredConfig config = repository.getConfig();
        String url = config.getString(BUGTRACK_SECTION, null, BUGTRACK_URL);
        if (url != null) {
            return TasksUiPlugin.getRepositoryManager().getRepository(url);
        }
        url = config.getString("remote", "origin", BUGTRACK_URL);
        if (url == null) {
            return null;
        }
        try {
            return this.getTaskRepositoryByHost(new URIish(url).getHost());
        }
        catch (Exception ex) {
            Platform.getLog(this.getClass()).log((IStatus)new Status(4, this.getClass(), "failed to get repo url", (Throwable)ex));
            return null;
        }
    }

    private TaskRepository getTaskRepositoryByHost(String host) {
        List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
        if (repositories == null || repositories.isEmpty()) {
            return null;
        }
        if (repositories.size() == 1) {
            return (TaskRepository)repositories.iterator().next();
        }
        for (TaskRepository repository : repositories) {
            if (repository.isOffline()) continue;
            try {
                URL url = new URL(repository.getRepositoryUrl());
                if (!this.isSameHosts(host, url.getHost())) continue;
                return repository;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isSameHosts(String name1, String name2) {
        String hostname2;
        String hostname1 = name1 == null ? LOCALHOST : name1.trim();
        String string = hostname2 = name2 == null ? LOCALHOST : name2.trim();
        if (hostname1.isEmpty()) {
            hostname1 = LOCALHOST;
        }
        if (hostname2.isEmpty()) {
            hostname2 = LOCALHOST;
        }
        return hostname1.equals(hostname2);
    }
}

