/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.apt.core.internal.env.BinaryFileOutputStream;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;

public class EncodedFileOutputStream
extends BinaryFileOutputStream {
    private final String _charsetName;

    public EncodedFileOutputStream(IFile file, BuildEnv env, String charsetName) {
        super(file, env);
        this._charsetName = charsetName;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._charsetName != null) {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IFile resourceFile = this._file.getProject().getFile(".settings/org.eclipse.core.resources.prefs");
            IStatus result = ws.validateEdit(new IFile[]{resourceFile}, IWorkspace.VALIDATE_PROMPT);
            if (result.getSeverity() == 8) {
                return;
            }
            try {
                String defaultCharset = this._file.getCharset();
                if (!this._charsetName.equalsIgnoreCase(defaultCharset)) {
                    this._file.setCharset(this._charsetName, null);
                }
            }
            catch (CoreException ce) {
                throw new IOException("Could not set charset: " + this._charsetName, ce);
            }
        }
    }
}

