/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.reviews.core.model.InternalRequirementStatus;

public enum RequirementStatus implements InternalRequirementStatus
{
    UNKNOWN(0, "Unknown", "UNKNOWN"),
    SATISFIED(1, "Satisfied", "SATISFIED"),
    OPTIONAL(2, "Optional", "OPTIONAL"),
    CLOSED(3, "Closed", "CLOSED"),
    NOT_SATISFIED(10, "NotSatisfied", "NOT_SATISFIED"),
    REJECTED(11, "Rejected", "REJECTED"),
    ERROR(100, "Error", "ERROR");

    public static final int UNKNOWN_VALUE = 0;
    public static final int SATISFIED_VALUE = 1;
    public static final int OPTIONAL_VALUE = 2;
    public static final int CLOSED_VALUE = 3;
    public static final int NOT_SATISFIED_VALUE = 10;
    public static final int REJECTED_VALUE = 11;
    public static final int ERROR_VALUE = 100;
    private static final RequirementStatus[] VALUES_ARRAY;
    public static final List<RequirementStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequirementStatus[]{UNKNOWN, SATISFIED, OPTIONAL, CLOSED, NOT_SATISFIED, REJECTED, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequirementStatus get(String literal) {
        RequirementStatus[] requirementStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementStatus result = requirementStatusArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static RequirementStatus getByName(String name) {
        RequirementStatus[] requirementStatusArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementStatus result = requirementStatusArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static RequirementStatus get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return SATISFIED;
            }
            case 2: {
                return OPTIONAL;
            }
            case 3: {
                return CLOSED;
            }
            case 10: {
                return NOT_SATISFIED;
            }
            case 11: {
                return REJECTED;
            }
            case 100: {
                return ERROR;
            }
        }
        return null;
    }

    private RequirementStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

